///////////////////////////////////////////////////////////
//  clCMTuningActionConfigurationSet.cpp
//  Implementation of the Class clCMTuningActionConfigurationSet
//  Created on:      01-Apr-2015 7:33:14 PM
///////////////////////////////////////////////////////////

#include "clCMTuningActionConfigurationSet.h"

#define ZERO                        0
#define NUMBEROFSEEKPERIODS         1
#define SCANTIME                    2
#define AFBESTDELAYTIME             3
#define TPSEEKSTRATEGY              4
#define PTYFILTER                   5
#define TUNINGSWITCHES              6
#define AUTOSEEKSTEPDELAY           7
#define MANUALSTEPDELAY             8
#define WRONGPISTEPDELAY            9
#define NONRDSDETECTIONTIMER       10
#define TPSEEKAFTERRDSLOSTTIMER    11
#define AMSTATIONINLISTREMOVETIMER 12
#define SCROLLINGPSDETECTIONTIMER  13
#define ALL                         0

clCMTuningActionConfigurationSet::clCMTuningActionConfigurationSet(){

}

clCMTuningActionConfigurationSet::~clCMTuningActionConfigurationSet(){

}

tunerVector<unsigned char> clCMTuningActionConfigurationSet::oSerialize(){

	tunerVector<unsigned char> payload;

	payload.push_back(Pos.x);
	payload.push_back(Pos.y);
	if(bSerializeAllElements())
	{
		vSerializeNumberOfSeekPeriods(payload, Pos.x);
		vSerializeScanTime(payload, Pos.x);
		vSerializeAfBestDelayTime(payload, Pos.x);
		vSerializeTPSeekStrategy(payload, Pos.x);
		vSerializePtyFilter(payload, Pos.x);
		vSerializeTuningSwitches(payload, Pos.x);
		vSerializeAutoSeekStepDelay(payload, Pos.x);
		vSerializeManualStepDelay(payload, Pos.x);
		vSerializeWrongPiAcceptDelay(payload, Pos.x);
		vSerializeNONRDSdetectionTimer(payload, Pos.x);
		vSerializeTPSeekAfterRDSlostTimer(payload, Pos.x);
		vSerializeAMStationInListRemoveTimer(payload, Pos.x);
		vSerializeScrollingPSdetectionTimer(payload, Pos.x);
	}
	else
	{
		SerializeIndividualItems(Pos.x, Pos.y, payload);
	}

	return payload;
}

void clCMTuningActionConfigurationSet::vSerializeNumberOfSeekPeriods(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == NUMBEROFSEEKPERIODS || xPos == ALL){
		payload.push_back(Data.NumberOfSeekPeriods);
	}
}
void clCMTuningActionConfigurationSet::vSerializeScanTime(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == SCANTIME || xPos == ALL){
		payload.push_back(Data.Scantime);
	}
}
void clCMTuningActionConfigurationSet::vSerializeAfBestDelayTime(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == AFBESTDELAYTIME || xPos == ALL){
		payload.push_back(Data.AfBestDelayTime);
	}
}
void clCMTuningActionConfigurationSet::vSerializeTPSeekStrategy(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == TPSEEKSTRATEGY || xPos == ALL){
		payload.push_back(static_cast<unsigned char>(Data.TPSeekStrategy.enType));
	}
}
void clCMTuningActionConfigurationSet::vSerializePtyFilter(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == PTYFILTER || xPos == ALL){
		vAddInt(payload, Data.PtyFilter);
	}
}
void clCMTuningActionConfigurationSet::vSerializeTuningSwitches(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == TUNINGSWITCHES || xPos == ALL){
		payload.push_back(Data.TuningSwitches);
	}
}
void clCMTuningActionConfigurationSet::vSerializeAutoSeekStepDelay(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == AUTOSEEKSTEPDELAY || xPos == ALL){
		vAddShort(payload, Data.AutoSeekStepDelay);
	}
}
void clCMTuningActionConfigurationSet::vSerializeManualStepDelay(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == MANUALSTEPDELAY || xPos == ALL){
		vAddShort(payload, Data.ManualStepDelay);
	}
}
void clCMTuningActionConfigurationSet::vSerializeWrongPiAcceptDelay(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == WRONGPISTEPDELAY || xPos == ALL){
		payload.push_back(Data.WrongPiAcceptDelay);
	}
}
void clCMTuningActionConfigurationSet::vSerializeNONRDSdetectionTimer(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == NONRDSDETECTIONTIMER || xPos == ALL){
		payload.push_back(Data.NONRDSdetectionTimer);
	}
}
void clCMTuningActionConfigurationSet::vSerializeTPSeekAfterRDSlostTimer(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == TPSEEKAFTERRDSLOSTTIMER || xPos == ALL){
		payload.push_back(Data.TPSeekAfterRDSlostTimer);
	}
}
void clCMTuningActionConfigurationSet::vSerializeAMStationInListRemoveTimer(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == AMSTATIONINLISTREMOVETIMER || xPos == ALL){
		payload.push_back(Data.AMStationInListRemoveTimer);
	}
}
void clCMTuningActionConfigurationSet::vSerializeScrollingPSdetectionTimer(tunerVector<unsigned char> &payload, unsigned char xPos){

	if(xPos == SCROLLINGPSDETECTIONTIMER || xPos == ALL){
		payload.push_back(Data.ScrollingPSdetectionTimer);
	}
}

bool clCMTuningActionConfigurationSet::bSerializeAllElements()
{
	if(Pos.x == ALL && Pos.y == ZERO){
		return true;
	}
	else {
		return false;
	}
}

void clCMTuningActionConfigurationSet::SerializeIndividualItems(unsigned char x, unsigned char y, tunerVector<unsigned char> &payload)
{
	if(y == ZERO)
	{
		vSerializeNumberOfSeekPeriods(payload, x);
		vSerializeScanTime(payload, x);
		vSerializeAfBestDelayTime(payload, x);
		vSerializeTPSeekStrategy(payload, x);
		vSerializePtyFilter(payload, x);
		vSerializeTuningSwitches(payload, x);
		vSerializeAutoSeekStepDelay(payload, x);
		vSerializeManualStepDelay(payload, x);
		vSerializeWrongPiAcceptDelay(payload, x);
		vSerializeNONRDSdetectionTimer(payload, x);
		vSerializeTPSeekAfterRDSlostTimer(payload, x);
		vSerializeAMStationInListRemoveTimer(payload, x);
		vSerializeScrollingPSdetectionTimer(payload, x);
	}
}

short clCMADRBaseType_TuningActionConfigurationData::getSize(unsigned char x, unsigned char y)
{
	short size = 0;

	size =(short)(size + getNumberOfSeekPeriodsSize(x, y));
	size =(short)(size + getScantimeSize(x, y));
	size =(short)(size + getAfBestDelayTimeSize(x, y));
	size =(short)(size + getTPSeekStrategySize(x, y));
	size =(short)(size + getPtyFilterSize(x, y));
	size =(short)(size + getTuningSwitchesSize(x, y));
	size =(short)(size + getAutoSeekStepDelaySize(x, y));
	size =(short)(size + getManualStepDelaySize(x, y));
	size =(short)(size + getWrongPiAcceptDelaySize(x, y));
	size =(short)(size + getNONRDSdetectionTimerSize(x, y));
	size =(short)(size + getTPSeekAfterRDSlostTimerSize(x, y));
	size =(short)(size + getAMStationInListRemoveTimerSize(x, y));
	size =(short)(size + getScrollingPSdetectionTimerSize(x, y));

	return size;
}

short clCMADRBaseType_TuningActionConfigurationData::getNumberOfSeekPeriodsSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == NUMBEROFSEEKPERIODS || x == ALL) && y == ZERO)
		Size = sizeof(NumberOfSeekPeriods);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getScantimeSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == SCANTIME || x == ALL) && y == ZERO)
		Size = sizeof(Scantime);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getAfBestDelayTimeSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == AFBESTDELAYTIME || x == ALL) && y == ZERO)
		Size = sizeof(AfBestDelayTime);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getTPSeekStrategySize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == TPSEEKSTRATEGY || x == ALL) && y == ZERO)
		Size = TPSeekStrategy.getSize();
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getPtyFilterSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == PTYFILTER || x == ALL) && y == ZERO)
		Size = sizeof(PtyFilter);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getTuningSwitchesSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == TUNINGSWITCHES || x == ALL) && y == ZERO)
		Size = sizeof(TuningSwitches);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getAutoSeekStepDelaySize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == AUTOSEEKSTEPDELAY || x == ALL) && y == ZERO)
		Size = sizeof(AutoSeekStepDelay);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getManualStepDelaySize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == MANUALSTEPDELAY || x == ALL) && y == ZERO)
		Size = sizeof(ManualStepDelay);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getWrongPiAcceptDelaySize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == WRONGPISTEPDELAY || x == ALL) && y == ZERO)
		Size = sizeof(WrongPiAcceptDelay);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getNONRDSdetectionTimerSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == NONRDSDETECTIONTIMER || x == ALL) && y == ZERO)
		Size = sizeof(NONRDSdetectionTimer);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getTPSeekAfterRDSlostTimerSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == TPSEEKAFTERRDSLOSTTIMER || x == ALL) && y == ZERO)
		Size = sizeof(TPSeekAfterRDSlostTimer);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getAMStationInListRemoveTimerSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == AMSTATIONINLISTREMOVETIMER || x == ALL) && y == ZERO)
		Size = sizeof(AMStationInListRemoveTimer);
	return Size;
}

short clCMADRBaseType_TuningActionConfigurationData::getScrollingPSdetectionTimerSize(unsigned char x, unsigned char y){

	short Size = 0;
	if((x == SCROLLINGPSDETECTIONTIMER || x == ALL) && y == ZERO)
		Size = sizeof(ScrollingPSdetectionTimer);
	return Size;
}

short clCMTuningActionConfigurationSet::u16GetSize(){

	return (short)(sizeof(Pos) + Data.getSize(Pos.x, Pos.y));
}

void clCMTuningActionConfigurationSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMTuningActionConfigurationSet::setPosition(clCMADRBaseType_Pos newPos){

	Pos = newPos;
}

void clCMTuningActionConfigurationSet::setData(clCMADRBaseType_TuningActionConfigurationData newData){

	Data = newData;
}
