///////////////////////////////////////////////////////////
//  clCMTestModeStatus.h
//  Implementation of the Class clCMTestModeStatus
//  Created on:      25-Jun-2015 1:47:10 PM
///////////////////////////////////////////////////////////

#if !defined(EA_6D6A6FFC_BFEA_4033_B7DA_A919CDDF69E0__INCLUDED_)
#define EA_6D6A6FFC_BFEA_4033_B7DA_A919CDDF69E0__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"
#include "datatypes/tString.h"

class clCMTestModeStatus : public clADRMsgPayload
{

public:
	/**
	 * Enumeration 0..6
	 * 0 UNKNOWN
	 * 1 FM
	 * 2 FM_NON_RDS
	 * 3 AM
	 * 4 DRM
	 * 5 HD
	 * 6 DAB
	 */
	clCMEnum_Modulation Modulation;
	/**
	 * Unsigned long word 150..108000
	 */
	unsigned int Frequency;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Quality;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Fieldstrength;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Multipath;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char NeighbourChannelDistortion;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char AFListLength;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Hicut;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Sharx;
	/**
	 * String of size 8 bytes
	 */
	tunerString Stationname;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char ChannelSeparation;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RdsErrorRate;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char Deviation;
	/**
	 * Boolean(1 bytes)
	 * Bit 0 False Unknown if station supports TP
	 *        True  Station supports TP
	 * Bit 1 False Unknown if station currently broadcasts a TA
	 *        True Station currently broadcasts a TA
	 * Bit 2 False Unknown if station supports TMC
	 *        True Station supports TMC
	 * Bit 3 False DDA not active
	 *        True DDA active
	 * Bit 4 False No audio tuner
	 *        True Audio tuner
	 * Bit 5..7 unused
	 */
	unsigned char InfoBits;

	clCMTestModeStatus();
	virtual ~clCMTestModeStatus();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * read TestModeStatus parameters
	 */
	clCMEnum_Modulation::enModulation getModulation();
	unsigned int getFrequency();
	unsigned short getPI();
	unsigned char getQuality();
	unsigned char getFieldstrength();
	unsigned char getMultipath();
	unsigned char getNeighbourChannelDistortion();
	unsigned char getAFListLength();
	unsigned char getHicut();
	unsigned char getSharx();
	tunerString getStationname();
	unsigned char getChannelSeparation();
	unsigned char getRdsErrorRate();
	unsigned char getDeviation();
	bool bIsTPSupported();
	bool bIsTAActive();
	bool bIsTMCSupported();
	bool bIsDDAActive();
	bool bIsAudioTunerOn();
};
#endif // !defined(EA_6D6A6FFC_BFEA_4033_B7DA_A919CDDF69E0__INCLUDED_)
