///////////////////////////////////////////////////////////
//  clCMTMCStationsStatus.cpp
//  Implementation of the Class clCMTMCStationsStatus
//  Created on:      23-Apr-2015 4:45:15 PM
///////////////////////////////////////////////////////////

#include "clCMTMCStationsStatus.h"
#define STATIONNAME_LEN 8

clCMTMCStationsStatus::clCMTMCStationsStatus(){

}

clCMTMCStationsStatus::~clCMTMCStationsStatus(){

}

tunerVector<unsigned char> clCMTMCStationsStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMTMCStationsStatus::u16GetSize(){

	return 0;
}

void clCMTMCStationsStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short Position = 0;

	Pos.x = bitStream[Position++];
	Pos.y = bitStream[Position++];

	Data.NumberOfStationsInList = bitStream[Position++];

	vConstructTMCStaionsDataStream(bitStream, Position, Data.NumberOfStationsInList);
}

void clCMTMCStationsStatus::vConstructTMCStaionsDataStream(tunerVector<unsigned char> bitStream,
		unsigned short Position, unsigned char NumberOfStaionsInList){

	while ((short)NumberOfStaionsInList != 0)
	{
		Data.DataStream.push_back(oGetTMCStationsData(bitStream, Position));
		NumberOfStaionsInList--;
	}
}

clCMADRBaseType_TMCStationsDataStream clCMTMCStationsStatus::oGetTMCStationsData(tunerVector<unsigned char> bitStream,
		unsigned short &position){

	unsigned char LSB = 0;
	unsigned char MSB = 0;
	clCMADRBaseType_TMCStationsDataStream oTMCStationsData;

	oTMCStationsData.Frequency = getInt(bitStream, position);
	position =(unsigned short)(position + sizeof(oTMCStationsData.Frequency));

	MSB = bitStream[position++];
	LSB = bitStream[position++];
	oTMCStationsData.PI = getWord(LSB, MSB);

	tunerString oStationName((const char *)&(bitStream[position]), STATIONNAME_LEN);
	oTMCStationsData.StationName = oStationName;
	position =(unsigned short)(position + STATIONNAME_LEN);

	oTMCStationsData.Quality = bitStream[position++];
	oTMCStationsData.RdbIdPrio = bitStream[position++];
	oTMCStationsData.CC = bitStream[position++];
	oTMCStationsData.LTN = bitStream[position++];
	oTMCStationsData.SID = bitStream[position++];
	oTMCStationsData.EncryptionFlag.enType = static_cast<clCMEnum_EncryptionFlag::enEncryptionFlag>(bitStream[position++]);

	return oTMCStationsData;
}

void clCMTMCStationsStatus::setPos(clCMADRBaseType_Pos newPos){

	Pos = newPos;
}

void clCMTMCStationsStatus::setData(clCMADRBaseType_TMCStationsData newData){

	Data.NumberOfStationsInList = newData.NumberOfStationsInList;
	unsigned char NumberOfStationsInList = newData.NumberOfStationsInList;
	clCMADRBaseType_TMCStationsDataStream oDataStream;
	unsigned short stringSize = 0;

	for(tunerVector<clCMADRBaseType_TMCStationsDataStream>::iterator it = newData.DataStream.begin();
			(it != newData.DataStream.end() && (short)NumberOfStationsInList != 0); it++)
	{
		oDataStream.Frequency = it->Frequency;
		oDataStream.PI = it->PI;

		stringSize = (unsigned short)it->StationName.size();
		if (stringSize > STATIONNAME_LEN)
		{
			stringSize = STATIONNAME_LEN;
		}
		tunerString oString(it->StationName.c_str(), stringSize);
		oDataStream.StationName = oString;

		oDataStream.Quality = it->Quality;
		oDataStream.RdbIdPrio = it->RdbIdPrio;
		oDataStream.CC = it->CC;
		oDataStream.LTN = it->LTN;
		oDataStream.SID = it->SID;
		oDataStream.EncryptionFlag.enType = it->EncryptionFlag.enType;

		Data.DataStream.push_back(oDataStream);
	}
}
