///////////////////////////////////////////////////////////
//  clCMSystemPreset.h
//  Implementation of the Class clCMSystemPreset
//  Created on:      09-Jan-2015 14:47:42
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_75B0E3E4_8BDB_492e_8803_0B37AD812480__INCLUDED_)
#define EA_75B0E3E4_8BDB_492e_8803_0B37AD812480__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"

/**
 * Class used to contain information related to the systemPreset function
 * @author pad1cob
 * @version 1.0
 * @created 09-Jan-2015 14:47:42
 */
class clCMSystemPreset : public clADRMsgPayload
{

public:
	clCMSystemPreset();
	virtual ~clCMSystemPreset();

	short getu16FktId();
	char getu8SystemPresetType();
	/**
	 * returns the size of the data stream
	 */
	virtual tunerVector<unsigned char> oSerialize();
	/**
	 * 
	 * @param newVal
	 */
	void setu16FktId(short newVal);
	/**
	 * 
	 * @param newVal
	 */
	void setu8SystemPresetType(char newVal);
	/**
	 * returns the size of the payload
	 */
	virtual short u16GetSize();
	/**
	 * 
	 * @param bitStream
	 */
	virtual void vConstruct(tunerVector<unsigned char> bitStream);

private:
	/**
	 * The FktId as defined in ADR spec
	 */
	short u16FktId;
	/**
	 * The systempresetType as defined in ADR spec
	 */
	char u8SystemPresetType;

};
#endif // !defined(EA_75B0E3E4_8BDB_492e_8803_0B37AD812480__INCLUDED_)
