///////////////////////////////////////////////////////////
//  clCMSystemPreset.cpp
//  Implementation of the Class clCMSystemPreset
//  Created on:      09-Jan-2015 14:47:42
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clCMSystemPreset.h"
#include "datatypes/tAlgorithm.h"

clCMSystemPreset::clCMSystemPreset()
   : u16FktId(0)
   , u8SystemPresetType(0)
{

}



clCMSystemPreset::~clCMSystemPreset(){

}





short clCMSystemPreset::getu16FktId(){

	return u16FktId;
}


char clCMSystemPreset::getu8SystemPresetType(){

	return u8SystemPresetType;
}


tunerVector<unsigned char> clCMSystemPreset::oSerialize(){

   tunerVector<unsigned char> payloadData;
   payloadData.push_back(getMSB(u16FktId));
   payloadData.push_back(getLSB(u16FktId));
   payloadData.push_back(u8SystemPresetType);
   return payloadData;
}


void clCMSystemPreset::setu16FktId(short newVal){

	u16FktId = newVal;
}


void clCMSystemPreset::setu8SystemPresetType(char newVal){

	u8SystemPresetType = newVal;
}


short clCMSystemPreset::u16GetSize(){

	return (sizeof(u16FktId) + sizeof(u8SystemPresetType));
}


void clCMSystemPreset::vConstruct(tunerVector<unsigned char> bitStream){

   short index = 0;
   unsigned char MSB = bitStream[index++];
   unsigned char LSB = bitStream[index++];
   u16FktId = getWord(LSB, MSB);
   u8SystemPresetType = bitStream[index++];
}
