///////////////////////////////////////////////////////////
//  clCMStationsListStatus.cpp
//  Implementation of the Class clCMStationsListStatus
//  Created on:      19-May-2015 12:22:04 PM
///////////////////////////////////////////////////////////

#include "clCMStationsListStatus.h"

#define ZERO                        0
#define SELECTED                    1
#define MODULATIONTYPE              2
#define FREQUENCY                   3
#define SENDERNAME_HDCALLSIGN_DRMSERVICELABEL 4
#define SENDERNAMEINFO              5
#define RDS_HD_DRM_PTY              6
#define PI_HDSTATIONID_DRMSERVICEID 7
#define TPINFO                      8
#define RECEPTIONQUALITY            9
#define _TMC                        10
#define PRESETLISTFORACMP           11
#define PRESETACMP                  12
#define LEVELCOMPENSATION           13
#define HDTEXTENCODING              14
#define HDNUMBEROFAUDIOPROGRAMS     15
#define DRM_LANGUAGE                16
#define DRMLANGUAGE_CODE            17
#define DRMCOUNTRY_CODE             18

clCMStationsListStatus::clCMStationsListStatus()
    : ListId(0){

}

clCMStationsListStatus::~clCMStationsListStatus(){

}

tunerVector<unsigned char> clCMStationsListStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMStationsListStatus::u16GetSize(){

	return 0;
}

void clCMStationsListStatus::vConstruct(tunerVector<unsigned char> bitStream)
{
	unsigned short position=0;

	Pos.x = bitStream[position++];
	Pos.y = bitStream[position++];

	vConstructData(bitStream, position);

	ListId = bitStream[position++];
}

void clCMStationsListStatus::setPos(clCMADRBaseType_Pos newPos)
{
	Pos = newPos;
}

void clCMStationsListStatus::setListId(unsigned char newListId)
{
	ListId = newListId;
}

void clCMStationsListStatus::setData(tunerVector<clCMADRBaseType_StationsListData> newData)
{
	Data.assign(newData.begin(), newData.end());
}

clCMADRBaseType_Pos clCMStationsListStatus::getPos()
{
	return Pos;
}

unsigned char clCMStationsListStatus::getListId()
{
	return ListId;
}

tunerVector<clCMADRBaseType_StationsListData> clCMStationsListStatus::getData()
{
	return Data;
}

void clCMStationsListStatus::vConstructData(tunerVector<unsigned char>& bitStream, unsigned short& position)
{
	if (bIsAllValuesSent())
	{
		vConstructAllValues(bitStream, position);
	}
	else
	{
		vConstructSelectedValues(bitStream, position);
	}
}

bool clCMStationsListStatus::bIsAllValuesSent()
{
	if (Pos.y == ZERO)
	{
		return true;
	}
	return false;
}

void clCMStationsListStatus::vConstructAllValues(tunerVector<unsigned char>& bitStream, unsigned short& position)
{
	if (bIsAllElementsSent())
	{
		while(position < bitStream.size()-sizeof(ListId))
		{
			vConstructRow(bitStream, position);
		}
	}
	else
	{
		vConstructRow(bitStream, position);
	}
}

bool clCMStationsListStatus::bIsAllElementsSent()
{
	if (Pos.x == ZERO)
	{
		return true;
	}
	return false;
}

void clCMStationsListStatus::vConstructSelectedValues(tunerVector<unsigned char>& bitStream, unsigned short& position)
{
	if (bIsAllElementsSent())
	{
		while(position < bitStream.size()-sizeof(ListId))
		{
			vConstructRow(bitStream, position);
		}
	}
	else
	{
		vConstructColumn(bitStream, Pos.y, position);
	}
}

void clCMStationsListStatus::vConstructRow(tunerVector<unsigned char>& bitStream, unsigned short& position)
{
	clCMADRBaseType_StationsListData oData;

	unsigned char TotalBytesInElement = oData.NumberOfBytesInElement = bitStream[position++];

	vConstructSelected(bitStream, SELECTED, position, oData);
	vConstructModulationType(bitStream, MODULATIONTYPE, position, oData);
	vConstructFrequency(bitStream, FREQUENCY, position, oData);
	vConstructSendername_HDCallSign_DRMServiceLabel(bitStream, SENDERNAME_HDCALLSIGN_DRMSERVICELABEL, position, oData);
	vConstructSendernameInfo(bitStream, SENDERNAMEINFO, position, oData);
	vConstructRDS_HD_DRM_Pty(bitStream, RDS_HD_DRM_PTY, position, oData);
	vConstructPI_HDStationId_DRMServiceId(bitStream, PI_HDSTATIONID_DRMSERVICEID, position, oData);
	vConstructTpInfo(bitStream, TPINFO, position, oData);
	vConstructReceptionQuality(bitStream, RECEPTIONQUALITY, position, oData);
	vConstructTMC(bitStream, _TMC, position, oData);
	vConstructPresetListForAcmp(bitStream, PRESETLISTFORACMP, position, oData);
	vConstructPresetAcmp(bitStream, PRESETACMP, position, oData);
	vConstructLevelCompensation(bitStream, LEVELCOMPENSATION, position, oData);
	vConstructHDTextEncoding(bitStream, HDTEXTENCODING,  position, oData);
	vConstructHDNumberOfAudioPrograms(bitStream, HDNUMBEROFAUDIOPROGRAMS,  position, oData);
	vConstructDrmlanguage(bitStream, DRM_LANGUAGE, position, oData);
	vConstructDrmlanguageCode(bitStream, DRMLANGUAGE_CODE, position, oData);
	vConstructDrmCountryCode(bitStream, DRMCOUNTRY_CODE, position, oData);

	oData.NumberOfBytesInElement = TotalBytesInElement;
	Data.push_back(oData);
}

void clCMStationsListStatus::vConstructColumn(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position)
{
	clCMADRBaseType_StationsListData oData;

	unsigned char TotalBytesInElement = oData.NumberOfBytesInElement = bitStream[position++];

	vConstructSelected(bitStream, column, position, oData);
	vConstructModulationType(bitStream, column, position, oData);
	vConstructFrequency(bitStream, column, position, oData);
	vConstructSendername_HDCallSign_DRMServiceLabel(bitStream, column, position, oData);
	vConstructSendernameInfo(bitStream, column, position, oData);
	vConstructRDS_HD_DRM_Pty(bitStream, column, position, oData);
	vConstructPI_HDStationId_DRMServiceId(bitStream, column, position, oData);
	vConstructTpInfo(bitStream, column, position, oData);
	vConstructReceptionQuality(bitStream, column, position, oData);
	vConstructTMC(bitStream, column, position, oData);
	vConstructPresetListForAcmp(bitStream, column, position, oData);
	vConstructPresetAcmp(bitStream, column, position, oData);
	vConstructLevelCompensation(bitStream, column, position, oData);
	vConstructHDTextEncoding(bitStream, column,  position, oData);
	vConstructHDNumberOfAudioPrograms(bitStream, column,  position, oData);
	vConstructDrmlanguage(bitStream, column, position, oData);
	vConstructDrmlanguageCode(bitStream, column, position, oData);
	vConstructDrmCountryCode(bitStream, column, position, oData);

	oData.NumberOfBytesInElement = TotalBytesInElement;
	Data.push_back(oData);
}

void clCMStationsListStatus::vConstructSelected(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == SELECTED && (int)oData.NumberOfBytesInElement >= oData.Selected.getSize())
	{
		oData.Selected.enType = static_cast<clCMEnum_Selected::enSelected>(bitStream[position++]);
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - oData.Selected.getSize());
	}
}

void clCMStationsListStatus::vConstructModulationType(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == MODULATIONTYPE && (int)oData.NumberOfBytesInElement >= oData.ModulationType.getSize())
	{
		oData.ModulationType.enType = static_cast<clCMEnum_ModulationType::enModulationType>(bitStream[position++]);
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - oData.ModulationType.getSize());
	}
}

void clCMStationsListStatus::vConstructFrequency(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == FREQUENCY && (int)oData.NumberOfBytesInElement >= sizeof(oData.Frequency))
	{
		oData.Frequency = getInt(bitStream, position);
		position =(unsigned short)(position + sizeof(oData.Frequency));
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.Frequency));
	}
}

void clCMStationsListStatus::vConstructSendername_HDCallSign_DRMServiceLabel(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == SENDERNAME_HDCALLSIGN_DRMSERVICELABEL && (int)oData.NumberOfBytesInElement >= (int)bitStream[position])
	{
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - bitStream[position]);
		oData.Sendername_HDCallSign_DRMServiceLabel.Construct(bitStream, position);
		oData.NumberOfBytesInElement--;
	}
}

void clCMStationsListStatus::vConstructSendernameInfo(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == SENDERNAMEINFO && (int)oData.NumberOfBytesInElement >= oData.SendernameInfo.getSize())
	{
		oData.SendernameInfo.enType = static_cast<clCMEnum_SendernameInfo::enSendernameInfo>(bitStream[position++]);
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - oData.SendernameInfo.getSize());
	}
}

void clCMStationsListStatus::vConstructRDS_HD_DRM_Pty(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == RDS_HD_DRM_PTY && (int)oData.NumberOfBytesInElement >= sizeof(oData.RDS_HD_DRM_Pty))
	{
		oData.RDS_HD_DRM_Pty = bitStream[position++];
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.RDS_HD_DRM_Pty));
	}
}

void clCMStationsListStatus::vConstructPI_HDStationId_DRMServiceId(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == PI_HDSTATIONID_DRMSERVICEID && (int)oData.NumberOfBytesInElement >= sizeof(oData.PI_HDStationId_DRMServiceId))
	{
		oData.PI_HDStationId_DRMServiceId = getInt(bitStream, position);
		position =(unsigned short)(position + sizeof(oData.PI_HDStationId_DRMServiceId));
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.PI_HDStationId_DRMServiceId));
	}
}

void clCMStationsListStatus::vConstructTpInfo(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == TPINFO && (int)oData.NumberOfBytesInElement >= sizeof(oData.TpInfo))
	{
		oData.TpInfo = (bitStream[position++])& (0x01);
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.TpInfo));
	}
}

void clCMStationsListStatus::vConstructReceptionQuality(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == RECEPTIONQUALITY && (int)oData.NumberOfBytesInElement >= sizeof(oData.ReceptionQuality))
	{
		oData.ReceptionQuality = bitStream[position++];
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.ReceptionQuality));
	}
}

void clCMStationsListStatus::vConstructTMC(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == _TMC && (int)oData.NumberOfBytesInElement >= oData.TMC.getSize())
	{
		oData.TMC.enType = static_cast<clCMEnum_TMC::enTMC>(bitStream[position++]);
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - oData.TMC.getSize());;
	}
}

void clCMStationsListStatus::vConstructPresetListForAcmp(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == PRESETLISTFORACMP && (int)oData.NumberOfBytesInElement >= sizeof(oData.PresetListForAcmp))
	{
		unsigned char MSB = bitStream[position++];
		unsigned char LSB = bitStream[position++];
		oData.PresetListForAcmp = getWord(LSB, MSB);
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.PresetListForAcmp));
	}
}

void clCMStationsListStatus::vConstructPresetAcmp(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == PRESETACMP && (int)oData.NumberOfBytesInElement >= sizeof(oData.PresetAcmp))
	{
		oData.PresetAcmp = bitStream[position++];
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.PresetAcmp));
	}
}

void clCMStationsListStatus::vConstructLevelCompensation(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == LEVELCOMPENSATION && (int)oData.NumberOfBytesInElement >= sizeof(oData.LevelCompensation))
	{
		oData.LevelCompensation = bitStream[position++];
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.LevelCompensation));
	}
}

void clCMStationsListStatus::vConstructHDTextEncoding(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == HDTEXTENCODING && (int)oData.NumberOfBytesInElement >= sizeof(oData.HDTextEncoding))
	{
		oData.HDTextEncoding = bitStream[position++];
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.HDTextEncoding));
	}
}

void clCMStationsListStatus::vConstructHDNumberOfAudioPrograms(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == HDNUMBEROFAUDIOPROGRAMS && (int)oData.NumberOfBytesInElement >= sizeof(oData.HDNumberOfAudioPrograms))
	{
		oData.HDNumberOfAudioPrograms = bitStream[position++];
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.HDNumberOfAudioPrograms));
	}
}

void clCMStationsListStatus::vConstructDrmlanguage(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == DRM_LANGUAGE && (int)oData.NumberOfBytesInElement >= sizeof(oData.Drmlanguage))
	{
		oData.Drmlanguage = bitStream[position++];
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - sizeof(oData.Drmlanguage));
	}
}

void clCMStationsListStatus::vConstructDrmlanguageCode(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == DRMLANGUAGE_CODE && (int)oData.NumberOfBytesInElement >= oData.DrmlanguageCode.getSize())
	{
		oData.DrmlanguageCode.enType = static_cast<clCMEnum_DrmlanguageCode::enDrmlanguageCode>(Construct3Bytes(bitStream, position));
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - oData.DrmlanguageCode.getSize());
	}
}

void clCMStationsListStatus::vConstructDrmCountryCode(tunerVector<unsigned char>& bitStream, unsigned char column, unsigned short& position, clCMADRBaseType_StationsListData& oData)
{
	if(column == DRMCOUNTRY_CODE && (int)oData.NumberOfBytesInElement >= oData.DrmCountryCode.getSize())
	{
		unsigned char MSB = bitStream[position++];
		unsigned char LSB = bitStream[position++];

		oData.DrmCountryCode.enType = static_cast<clCMEnum_DrmCountryCode::enDrmCountryCode>(getWord(LSB, MSB));
		oData.NumberOfBytesInElement =(unsigned char)(oData.NumberOfBytesInElement - oData.DrmCountryCode.getSize());
	}
}
