///////////////////////////////////////////////////////////
//  clCMStationsListSetGet.h
//  Implementation of the Class clCMStationsListSetGet
//  Created on:      19-May-2015 12:10:27 PM
///////////////////////////////////////////////////////////

#if !defined(EA_0AA89C47_DE94_4d7c_9676_E25535B5F7D7__INCLUDED_)
#define EA_0AA89C47_DE94_4d7c_9676_E25535B5F7D7__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMADRBaseTypes.h"

class clCMStationsListSetGet : public clADRMsgPayload
{

public:
	/**
	 * X=0..NMAX, y=0..18
	 */
	clCMADRBaseType_Pos Pos;
	/**
	 * Stream
	 */
	tunerVector<clCMADRBaseType_StationsListData> Data;
	/**
	 * Unsigned byte 0..7
	 */
	unsigned char ListId;

	clCMStationsListSetGet();
	virtual ~clCMStationsListSetGet();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	clCMADRBaseType_StationsListData& getData(unsigned short index);
	void vSerializeData(tunerVector<unsigned char>& payload);
	void vSerializeAllValues(tunerVector<unsigned char>& payload);
	void vSerializeSelectedValues(tunerVector<unsigned char>& payload);
	void vSerializeRow(tunerVector<unsigned char>& payload, unsigned short index, unsigned char& ListStartIndex);
	void vSerializeColumn(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column, unsigned char& ListStartIndex);
	void vSerializeSelected(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeModulationType(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeFrequency(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeSendername_HDCallSign_DRMServiceLabel(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeSendernameInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeRDS_HD_DRM_Pty(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializePI_HDStationId_DRMServiceId(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeTpInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeReceptionQuality(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeTMC(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializePresetListForAcmp(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializePresetAcmp(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeLevelCompensation(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeHDTextEncoding(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeHDNumberOfAudioPrograms(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeDrmlanguage(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeDrmlanguageCode(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);
	void vSerializeDrmCountryCode(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column);

	bool bIsAllElementsRequested();
	bool bIsAllValuesRequested();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	unsigned char getSizeOfModulationType(clCMEnum_ModulationType::enModulationType val);
	bool bIsFixedLengthString(clCMEnum_ModulationType::enModulationType val);
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set StationsListSet parameters
	 */
	void setPos(clCMADRBaseType_Pos newPos);
	void setData(tunerVector<clCMADRBaseType_StationsListData> newData);
	void setListId(unsigned char newListId);

};
#endif // !defined(EA_0AA89C47_DE94_4d7c_9676_E25535B5F7D7__INCLUDED_)
