///////////////////////////////////////////////////////////
//  clCMStationsListSet.cpp
//  Implementation of the Class clCMStationsListSet
//  Created on:      28-Apr-2015 3:01:38 PM
///////////////////////////////////////////////////////////

#include "clCMStationsListSet.h"

#define ZERO                        0
#define SELECTED                    1
#define MODULATIONTYPE              2
#define FREQUENCY                   3
#define SENDERNAME_HDCALLSIGN_DRMSERVICELABEL 4
#define SENDERNAMEINFO              5
#define RDS_HD_DRM_PTY              6
#define PI_HDSTATIONID_DRMSERVICEID 7
#define TPINFO                      8
#define RECEPTIONQUALITY            9
#define _TMC                        10
#define PRESETLISTFORACMP           11
#define PRESETACMP                  12
#define LEVELCOMPENSATION           13
#define HDTEXTENCODING              14
#define HDNUMBEROFAUDIOPROGRAMS     15
#define DRM_LANGUAGE                16
#define DRMLANGUAGE_CODE            17
#define DRMCOUNTRY_CODE             18

#define AM_FM_STR_LEN               8
#define HD_STR_LEN                  16
#define DRM_STR_LEN                 64

clCMStationsListSet::clCMStationsListSet() : ListId(0){

}

clCMStationsListSet::~clCMStationsListSet(){

}

clCMADRBaseType_StationsListData& clCMStationsListSet::getData(unsigned short index)
{
	if(index != 0)
	{
		return Data[--index];
	}
	return Data[index];
}

tunerVector<unsigned char> clCMStationsListSet::oSerialize()
{
	tunerVector<unsigned char> payload;

	payload.push_back(Pos.x);
	payload.push_back(Pos.y);

	vSerializeData(payload);

	payload.push_back(ListId);

	return payload;
}

bool clCMStationsListSet::bIsAllElementsRequested(){

	if(Pos.x == ZERO){
		return true;
	}
	else {
		return false;
	}
}

bool clCMStationsListSet::bIsAllValuesRequested()
{
	if(Pos.y == ZERO){
		return true;
	}
	else {
		return false;
	}
}

void clCMStationsListSet::vSerializeData(tunerVector<unsigned char>& payload)
{
	if (bIsAllValuesRequested())
	{
		vSerializeAllValues(payload);
	}
	else
	{
		vSerializeSelectedValues(payload);
	}
}

void clCMStationsListSet::vSerializeAllValues(tunerVector<unsigned char>& payload)
{
	unsigned char ListStartIndex = (unsigned char)payload.size();
	if (bIsAllElementsRequested())
	{
		for (unsigned short index = 1; index <= Data.size(); index++)
		{
			vSerializeRow(payload, index, ListStartIndex);
		}
	}
	else
	{
		vSerializeRow(payload, Pos.x, ListStartIndex);
	}
}

void clCMStationsListSet::vSerializeSelectedValues(tunerVector<unsigned char>& payload)
{
	unsigned char ListStartIndex = (unsigned char)payload.size();
	if (bIsAllElementsRequested())
	{
		for (unsigned short index = 1; index <= Data.size(); index++)
		{
			vSerializeColumn(payload, index, Pos.y, ListStartIndex);
		}
	}
	else
	{
		vSerializeColumn(payload, Pos.x, Pos.y, ListStartIndex);
	}
}

unsigned char clCMStationsListSet::getSizeOfModulationType(clCMEnum_ModulationType::enModulationType val)
{
	unsigned char size=0;

	if(val == clCMEnum_ModulationType::Analogue_AM_FM)
	{
		size = AM_FM_STR_LEN;
	}
	else if(val == clCMEnum_ModulationType::HD)
	{
		size = HD_STR_LEN;
	}
	else if(val == clCMEnum_ModulationType::DRM)
	{
		size = DRM_STR_LEN;
	}
	return size;
}

bool clCMStationsListSet::bIsFixedLengthString(clCMEnum_ModulationType::enModulationType val)
{
	if(val == clCMEnum_ModulationType::Analogue_AM_FM)
	{
		return true;
	}
	else
		return false;
}

void clCMStationsListSet::vSerializeRow(tunerVector<unsigned char>& payload, unsigned short index, unsigned char& ListStartIndex)
{
	payload.push_back(getData(index).NumberOfBytesInElement);
	vSerializeSelected(payload, index, SELECTED);
	vSerializeModulationType(payload, index, MODULATIONTYPE);
	vSerializeFrequency(payload, index, FREQUENCY);
	vSerializeSendername_HDCallSign_DRMServiceLabel(payload, index, SENDERNAME_HDCALLSIGN_DRMSERVICELABEL);
	vSerializeSendernameInfo(payload, index, SENDERNAMEINFO);
	vSerializeRDS_HD_DRM_Pty(payload, index, RDS_HD_DRM_PTY);
	vSerializePI_HDStationId_DRMServiceId(payload, index, PI_HDSTATIONID_DRMSERVICEID);
	vSerializeTpInfo(payload, index, TPINFO);
	vSerializeReceptionQuality(payload, index, RECEPTIONQUALITY);
	vSerializeTMC(payload, index, _TMC);
	vSerializePresetListForAcmp(payload, index, PRESETLISTFORACMP);
	vSerializePresetAcmp(payload, index, PRESETACMP);
	vSerializeLevelCompensation(payload, index, LEVELCOMPENSATION);
	vSerializeHDTextEncoding(payload, index, HDTEXTENCODING);
	vSerializeHDNumberOfAudioPrograms(payload, index, HDNUMBEROFAUDIOPROGRAMS);
	vSerializeDrmlanguage(payload, index, DRM_LANGUAGE);
	vSerializeDrmlanguageCode(payload, index, DRMLANGUAGE_CODE);
	vSerializeDrmCountryCode(payload, index, DRMCOUNTRY_CODE);
	
	payload[ListStartIndex] = getData(index).NumberOfBytesInElement;
	ListStartIndex = (unsigned char)payload.size();
}

void clCMStationsListSet::vSerializeColumn(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column, unsigned char& ListStartIndex)
{
	payload.push_back(getData(index).NumberOfBytesInElement);
	vSerializeSelected(payload, index, column);
	vSerializeModulationType(payload, index, column);
	vSerializeFrequency(payload, index, column);
	vSerializeSendername_HDCallSign_DRMServiceLabel(payload, index, column);
	vSerializeSendernameInfo(payload, index, column);
	vSerializeRDS_HD_DRM_Pty(payload, index, column);
	vSerializePI_HDStationId_DRMServiceId(payload, index, column);
	vSerializeTpInfo(payload, index, column);
	vSerializeReceptionQuality(payload, index, column);
	vSerializeTMC(payload, index, column);
	vSerializePresetListForAcmp(payload, index, column);
	vSerializePresetAcmp(payload, index, column);
	vSerializeLevelCompensation(payload, index, column);
	vSerializeHDTextEncoding(payload, index, column);
	vSerializeHDNumberOfAudioPrograms(payload, index, column);
	vSerializeDrmlanguage(payload, index, column);
	vSerializeDrmlanguageCode(payload, index, column);
	vSerializeDrmCountryCode(payload, index, column);
	
	payload[ListStartIndex] = getData(index).NumberOfBytesInElement;
	ListStartIndex = (unsigned char)payload.size();
}

void clCMStationsListSet::vSerializeSelected(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == SELECTED){
		payload.push_back(static_cast<unsigned char>(getData(index).Selected.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).Selected.getSize());
	}
}

void clCMStationsListSet::vSerializeModulationType(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == MODULATIONTYPE){
		payload.push_back(static_cast<unsigned char>(getData(index).ModulationType.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).ModulationType.getSize());
	}
}

void clCMStationsListSet::vSerializeFrequency(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == FREQUENCY){
		vAddInt(payload, getData(index).Frequency);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).Frequency));
	}
}

void clCMStationsListSet::vSerializeSendername_HDCallSign_DRMServiceLabel(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	unsigned char size = getSizeOfModulationType(getData(index).ModulationType.enType);
	bool bIsFixedLength = bIsFixedLengthString(getData(index).ModulationType.enType);
	if(column == SENDERNAME_HDCALLSIGN_DRMSERVICELABEL)
	{
		unsigned char ActualStringSize = (unsigned char)getData(index).Sendername_HDCallSign_DRMServiceLabel.szValue.size();
		getData(index).Sendername_HDCallSign_DRMServiceLabel.Serialize(payload, size, bIsFixedLength);
		if( (ActualStringSize < size) && (ActualStringSize != 0) )
		{
			if(bIsFixedLength == true)
			{
				getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + size);
			}
			else
			{
				getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).Sendername_HDCallSign_DRMServiceLabel.szValue.size());
			}
		}
		else if(ActualStringSize != 0)
		{
			getData(index).NumberOfBytesInElement = (unsigned char)(getData(index).NumberOfBytesInElement + size);
		}
		getData(index).NumberOfBytesInElement++;
	}
}

void clCMStationsListSet::vSerializeSendernameInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == SENDERNAMEINFO){
		payload.push_back(static_cast<unsigned char>(getData(index).SendernameInfo.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).SendernameInfo.getSize());
	}
}

void clCMStationsListSet::vSerializeRDS_HD_DRM_Pty(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == RDS_HD_DRM_PTY){
		payload.push_back(getData(index).RDS_HD_DRM_Pty);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).RDS_HD_DRM_Pty));
	}
}

void clCMStationsListSet::vSerializePI_HDStationId_DRMServiceId(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == PI_HDSTATIONID_DRMSERVICEID){
		vAddInt(payload, getData(index).PI_HDStationId_DRMServiceId);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).PI_HDStationId_DRMServiceId));
	}
}

void clCMStationsListSet::vSerializeTpInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == TPINFO){
		payload.push_back(getData(index).TpInfo);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).TpInfo));
	}
}

void clCMStationsListSet::vSerializeReceptionQuality(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == RECEPTIONQUALITY){
		payload.push_back(getData(index).ReceptionQuality);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).ReceptionQuality));
	}
}

void clCMStationsListSet::vSerializeTMC(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == _TMC){
		payload.push_back(static_cast<unsigned char>(getData(index).TMC.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).TMC.getSize());
	}
}

void clCMStationsListSet::vSerializePresetListForAcmp(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == PRESETLISTFORACMP){
		vAddShort(payload, getData(index).PresetListForAcmp);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).PresetListForAcmp));
	}
}

void clCMStationsListSet::vSerializePresetAcmp(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == PRESETACMP){
		payload.push_back(getData(index).PresetAcmp);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).PresetAcmp));
	}
}

void clCMStationsListSet::vSerializeLevelCompensation(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == LEVELCOMPENSATION){
		payload.push_back(getData(index).LevelCompensation);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).LevelCompensation));
	}
}

void clCMStationsListSet::vSerializeHDTextEncoding(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == HDTEXTENCODING){
		payload.push_back(getData(index).HDTextEncoding);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).HDTextEncoding));
	}
}

void clCMStationsListSet::vSerializeHDNumberOfAudioPrograms(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == HDNUMBEROFAUDIOPROGRAMS){
		payload.push_back(getData(index).HDNumberOfAudioPrograms);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).HDNumberOfAudioPrograms));
	}
}

void clCMStationsListSet::vSerializeDrmlanguage(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == DRM_LANGUAGE){
		payload.push_back(getData(index).Drmlanguage);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).Drmlanguage));
	}
}

void clCMStationsListSet::vSerializeDrmlanguageCode(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == DRMLANGUAGE_CODE){
		vAdd3Bytes(payload, static_cast<unsigned int>(getData(index).DrmlanguageCode.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).DrmlanguageCode.getSize());
	}
}

void clCMStationsListSet::vSerializeDrmCountryCode(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == DRMCOUNTRY_CODE){
		vAddShort(payload, static_cast<unsigned short>(getData(index).DrmCountryCode.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).DrmCountryCode.getSize());
	}
}

short clCMStationsListSet::u16GetSize(){

	return 0; //dynamic content
}

void clCMStationsListSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMStationsListSet::setPos(clCMADRBaseType_Pos newPos)
{
	Pos = newPos;
}

void clCMStationsListSet::setListId(unsigned char newListId)
{
	ListId = newListId;
}

void clCMStationsListSet::setData(tunerVector<clCMADRBaseType_StationsListData> newData)
{
	Data.assign(newData.begin(), newData.end());
}
