///////////////////////////////////////////////////////////
//  clCMStationListConfigStartResult.cpp
//  Implementation of the Class clCMStationListConfigStartResult
//  Created on:      13-Apr-2015 7:16:37 PM
///////////////////////////////////////////////////////////

#include "clCMStationListConfigStartResult.h"

clCMStationListConfigStartResult::clCMStationListConfigStartResult()
    : ListId(0),
      Band(0),
      DigitalFilter(0),
      PtyFilter(0),
      rfu_byte_0(0),
      rfu_byte_1(0),
      rfu_byte_2(0),
      rfu_byte_3(0){

}

clCMStationListConfigStartResult::~clCMStationListConfigStartResult(){

}

tunerVector<unsigned char> clCMStationListConfigStartResult::oSerialize(){

	tunerVector<unsigned char> payload;

	payload.push_back(ListId);
	vAddInt(payload, Band);
	payload.push_back(static_cast<unsigned char>(AnalogFilter.enType));
	payload.push_back(DigitalFilter);
	vAddInt(payload, PtyFilter);
	payload.push_back(static_cast<unsigned char>(Sorting.enType));
	payload.push_back(rfu_byte_0);
	payload.push_back(rfu_byte_1);
	payload.push_back(rfu_byte_2);
	payload.push_back(rfu_byte_3);

	return payload;
}

short clCMStationListConfigStartResult::u16GetSize(){

	short size = 0;
	size = (short)(sizeof(ListId) + sizeof(Band) + AnalogFilter.getSize()
			+ sizeof(DigitalFilter) + sizeof(PtyFilter) + Sorting.getSize()
			+ sizeof(rfu_byte_0) + sizeof(rfu_byte_1) + sizeof(rfu_byte_2)
			+ sizeof(rfu_byte_3));
	return size;
}

void clCMStationListConfigStartResult::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMStationListConfigStartResult::setListId(unsigned char newListId){

	ListId = newListId;
}

void clCMStationListConfigStartResult::setBand(unsigned int newBand){

	Band = newBand;
}

void clCMStationListConfigStartResult::setAnalogFilter(clCMEnum_AnalogFilter::enAnalogFilter newAnalogFilter){

	AnalogFilter.enType = newAnalogFilter;
}

void clCMStationListConfigStartResult::setDigitalFilter(unsigned char newDigitalFilter){

	DigitalFilter = newDigitalFilter;
}

void clCMStationListConfigStartResult::setPtyFilter(unsigned int newPtyFilter){

	PtyFilter = newPtyFilter;
}

void clCMStationListConfigStartResult::setSorting(clCMEnum_Sorting::enSorting newSorting){

	Sorting.enType = newSorting;
}
void clCMStationListConfigStartResult::setrfu_byte_0(unsigned char newrfu_byte_0){

	rfu_byte_0 = newrfu_byte_0;
}

void clCMStationListConfigStartResult::setrfu_byte_1(unsigned char newrfu_byte_1){

	rfu_byte_1 = newrfu_byte_1;
}

void clCMStationListConfigStartResult::setrfu_byte_2(unsigned char newrfu_byte_2){

	rfu_byte_2 = newrfu_byte_2;
}

void clCMStationListConfigStartResult::setrfu_byte_3(unsigned char newrfu_byte_3){

	rfu_byte_3 = newrfu_byte_3;
}
