///////////////////////////////////////////////////////////
//  clCMSpecialDiagnosisMode.cpp
//  Implementation of the Class clCMSpecialDiagnosisMode
//  Created on:      12-Jan-2015 14:47:42
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clCMSpecialDiagnosisMode.h"
#include "datatypes/tAlgorithm.h"

#include "tuner_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clCMSpecialDiagnosisMode.cpp.trc.h"
#endif

clCMSpecialDiagnosisMode::clCMSpecialDiagnosisMode()
 : Mode(NORMAL_MODE) 
 , PhysicalTunerId(0) 
{

}



clCMSpecialDiagnosisMode::~clCMSpecialDiagnosisMode(){

}


tunerVector<unsigned char> clCMSpecialDiagnosisMode::oSerialize(){

   tunerVector<unsigned char> payloadData;
   payloadData.push_back(Mode);
   payloadData.push_back(PhysicalTunerId);
   return payloadData;
}


short clCMSpecialDiagnosisMode::u16GetSize(){

	return (sizeof(Mode) + sizeof(PhysicalTunerId));
}


void clCMSpecialDiagnosisMode::vConstruct(tunerVector<unsigned char> bitStream){
   
   unsigned short index = 0;
   if (bitStream.size())
   {
      Mode = bitStream[index++];
      PhysicalTunerId = bitStream[index++];
   }
}
