///////////////////////////////////////////////////////////
//  clCMSetConfigSectionsStartResult.cpp
//  Implementation of the Class clCMSetConfigSectionsStartResult
//  Created on:      26-Jun-2015 3:42:40 PM
///////////////////////////////////////////////////////////

#include "clCMSetConfigSectionsStartResult.h"

#define VERSIONINFO_LEN 16

clCMSetConfigSectionsStartResult::clCMSetConfigSectionsStartResult()
    : rfu_byte_0(0),
      rfu_byte_1(0),
      rfu_byte_2(0),
      rfu_byte_3(0),
      rfu_byte_4(0),
      rfu_byte_5(0),
      rfu_byte_6(0),
      rfu_byte_7(0),
	  NumberOfBytes(0){

}

clCMSetConfigSectionsStartResult::~clCMSetConfigSectionsStartResult(){

}

void clCMSetConfigSectionsStartResult::oSerializeRFU_bytes(tunerVector<unsigned char> &payload)
{
	payload.push_back(rfu_byte_0);
	payload.push_back(rfu_byte_1);
	payload.push_back(rfu_byte_2);
	payload.push_back(rfu_byte_3);
	payload.push_back(rfu_byte_4);
	payload.push_back(rfu_byte_5);
	payload.push_back(rfu_byte_6);
	payload.push_back(rfu_byte_7);
}

tunerVector<unsigned char> clCMSetConfigSectionsStartResult::oSerialize(){

	tunerVector<unsigned char> payload;
	char *pStr = const_cast<char *>(VersionInfo.c_str());

	oSerializeRFU_bytes(payload);

	if(VersionInfo.size() < VERSIONINFO_LEN)
	{
		int index=0;
		for(; index < (int)VersionInfo.size(); index++)
		{
			payload.push_back(pStr[index]);
		}
		for(; index < VERSIONINFO_LEN; index++)
		{
			payload.push_back((unsigned char)0);
		}
	}
	else
	{
		vAddString(payload, (unsigned char *)pStr, VERSIONINFO_LEN);
	}
	vAddShort(payload, NumberOfBytes);
	payload.insert(payload.end(), Byte0_n.begin(), Byte0_n.begin() + NumberOfBytes);

	unsigned short payloadDataSize = (unsigned short)payload.size();
	payload.insert(payload.begin(), getLSB(payloadDataSize));
	payload.insert(payload.begin(), getMSB(payloadDataSize));

	return payload;
}

short clCMSetConfigSectionsStartResult::u16GetSize(){

	return 0;
}

bool clCMSetConfigSectionsStartResult::bIsStaticSize(){

	return false;
}

void clCMSetConfigSectionsStartResult::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMSetConfigSectionsStartResult::setVersionInfo(tunerString newVersionInfo)
{
	unsigned short StrSize = (unsigned short)newVersionInfo.size();
	if(StrSize > VERSIONINFO_LEN)
	{
		StrSize = VERSIONINFO_LEN;
	}
	tunerString oString(newVersionInfo.c_str(), StrSize);
	VersionInfo = oString;
}

void clCMSetConfigSectionsStartResult::setNumberOfBytes(unsigned short newNumberOfBytes)
{
	NumberOfBytes = newNumberOfBytes;
}

void clCMSetConfigSectionsStartResult::setByte0_n(tunerVector<unsigned char> newByte0_n)
{
	Byte0_n.assign(newByte0_n.begin(), newByte0_n.end());
}
