///////////////////////////////////////////////////////////
//  clCMHDTestModeStatus.cpp
//  Implementation of the Class clCMHDTestModeStatus
//  Created on:      26-Feb-2015 5:46:59 PM
///////////////////////////////////////////////////////////

#include "clCMHDTestModeStatus.h"
#include <string.h>

#define TESTMODESTATUS_HDCALLSIGN_LEN           16

clCMHDTestModeStatus::clCMHDTestModeStatus() : HDStationId(0),
AvailableAudioprograms(0),
AudioQuality(0),
HDStationInfoBits(0),
CD_N0(0)
{
	
}

clCMHDTestModeStatus::~clCMHDTestModeStatus(){

}

tunerVector<unsigned char> clCMHDTestModeStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMHDTestModeStatus::u16GetSize(){

	return 0;
}

void clCMHDTestModeStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short pos = 0;

	tunerString oHDCallSignString ((const char *)&(bitStream[pos]), TESTMODESTATUS_HDCALLSIGN_LEN);
	HDCallSign = oHDCallSignString;
	pos =(unsigned short)(pos + TESTMODESTATUS_HDCALLSIGN_LEN);

	HDStationId = getInt(bitStream[pos], bitStream[pos+1], bitStream[pos+2], bitStream[pos+3]);
	pos =(unsigned short)(pos + sizeof(HDStationId));

	AvailableAudioprograms = bitStream[pos++];

	ActiveAudioprogram.enType = static_cast<clCMEnum_ATHDAudioProgram::enATHDAudioProgram>(bitStream[pos++]);

	AudioQuality = bitStream[pos++];

	HDStationInfoBits = bitStream[pos++];

	CD_N0 = bitStream[pos++];


}

void clCMHDTestModeStatus::setHDCallSign(tunerString newHDCallSign){

	unsigned short stringSize = (unsigned short)newHDCallSign.size();
	if (newHDCallSign.size() > TESTMODESTATUS_HDCALLSIGN_LEN)
	{
		stringSize = TESTMODESTATUS_HDCALLSIGN_LEN;
	}
	tunerString oString(newHDCallSign.c_str(), stringSize);
	HDCallSign = oString;
}

void clCMHDTestModeStatus::setHDStationId(unsigned char newHDStationId){

	HDStationId = newHDStationId;
}

void clCMHDTestModeStatus::setAvailableAudioprograms(unsigned char newAvailableAudioprograms){

	AvailableAudioprograms = newAvailableAudioprograms;
}

void clCMHDTestModeStatus::setActiveAudioprogram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newActiveAudioprogram){

	ActiveAudioprogram.enType = newActiveAudioprogram;
}

void clCMHDTestModeStatus::setAudioQuality(unsigned char newAudioQuality){

	AudioQuality = newAudioQuality;
}

void clCMHDTestModeStatus::setHDStationInfoBits(unsigned char newHDStationInfoBits){

	HDStationInfoBits = newHDStationInfoBits;
}

void clCMHDTestModeStatus::setCD_N0(unsigned char newCD_N0){

	CD_N0 = newCD_N0;
}


const char * clCMHDTestModeStatus::getHDCallSign() const{

	return HDCallSign.c_str();
}
unsigned int clCMHDTestModeStatus::getHDStationId(){

	return HDStationId;
}

unsigned char clCMHDTestModeStatus::getAvailableAudioprograms(){

	return AvailableAudioprograms;
}

clCMEnum_ATHDAudioProgram::enATHDAudioProgram clCMHDTestModeStatus::getActiveAudioprogram(){

	return ActiveAudioprogram.enType;
}

unsigned char clCMHDTestModeStatus::getAudioQuality(){

	return AudioQuality;
}

unsigned char clCMHDTestModeStatus::getHDStationInfoBits(){

	return HDStationInfoBits;
}
unsigned char clCMHDTestModeStatus::getCD_N0(){

	return CD_N0;
}
