///////////////////////////////////////////////////////////
//  clCMHDFirmwareInfoStatus.h
//  Implementation of the Class clCMHDFirmwareInfoStatus
//  Created on:      05-Feb-2015 3:09:27 PM
///////////////////////////////////////////////////////////

#if !defined(EA_C0690578_E1E4_41d4_98A4_152915FA8162__INCLUDED_)
#define EA_C0690578_E1E4_41d4_98A4_152915FA8162__INCLUDED_

#include "clADRMsgPayload.h"
#include "clByteConverter.h"
#include "datatypes/tString.h"

#define HDFIRMWAREINFO_LEN			36

class clCMHDFirmwareInfoStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMHDFirmwareInfoStatus();
	/**
	 * Destructor
	 */
	virtual ~clCMHDFirmwareInfoStatus();
	/**
	 * Name string of the HD decoder firmware version
	 */
	tunerString HDFirmwareInfo;
	/**
	 * Reserved for later use
	 */
	unsigned char RFU_Byte_0;
	unsigned char RFU_Byte_1;
	unsigned char RFU_Byte_2;
	unsigned char RFU_Byte_3;
	unsigned char RFU_Byte_4;
	unsigned char RFU_Byte_5;
	unsigned char RFU_Byte_6;
	unsigned char RFU_Byte_7;
	unsigned char RFU_Byte_8;
	unsigned char RFU_Byte_9;
	unsigned char RFU_Byte_10;
	unsigned char RFU_Byte_11;
	unsigned char RFU_Byte_12;
	unsigned char RFU_Byte_13;
	unsigned char RFU_Byte_14;
	unsigned char RFU_Byte_15;
	unsigned char RFU_Byte_16;
	unsigned char RFU_Byte_17;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Read HD firmware info
	 */
	const char * getHDFirmwareInfo() const;
	/**
	 * Set HD firmware info
	 */
	void setHDFirmwareInfo(tunerString newversion);
	/**
	 * Set RFU bytes
	 */
	void setRFU_Bytes(tunerVector<unsigned char> RFU_Bytes);
	/**
	 * Read RFU bytes
	 */
	tunerVector<unsigned char> getRFU_Bytes();

};
#endif // !defined(EA_C0690578_E1E4_41d4_98A4_152915FA8162__INCLUDED_)
