///////////////////////////////////////////////////////////
//  clCMError.h
//  Implementation of the Class clCMPingError
//  Created on:      04-Feb-2015 12:30:18 PM
///////////////////////////////////////////////////////////

#if !defined(__CL_CM_ERROR_INCLUDED__)
#define __CL_CM_ERROR_INCLUDED__

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"
#include "types/clCMErrorTypes.h"

class clCMError : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMError();
	/**
	 * Destructor
	 */
	virtual ~clCMError();
	/**
	 * Unsigned byte 0..0xff
	 */
	clCMErrorCodes ErrorCode;
	clCMErrorInfo ErrorInfo;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize() ;
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Read Error code
	 */
	clCMErrorCodes::ErrorCode getErrorCode() const;
	/**
	 * Read Error info
	 */
	clCMErrorInfo::ErrorInfo getErrorInfo() const;
	/**
	 * Set Error code
	 */
	void setErrorCode(clCMErrorCodes::ErrorCode newErrorCode);
	/**
	 * Read Error info
	 */
	void setErrorInfo(clCMErrorInfo::ErrorInfo newErrorCode);

};

#endif // !defined(EA_B9D47CD3_C700_4e5c_9534_F18C7687840D__INCLUDED_)
