///////////////////////////////////////////////////////////
//  clCMDrmTestModeStatus.cpp
//  Implementation of the Class clCMDrmTestModeStatus
//  Created on:      08-Jul-2015 8:27:58 PM
///////////////////////////////////////////////////////////

#include "clCMDrmTestModeStatus.h"

#define SERVICE_LEN       6

clCMDrmTestModeStatus::clCMDrmTestModeStatus() : TunerInfo(0),
Frequency(0),
FieldStrength(0),
SyncStatus(0),
RobustnessMode(0),
ChannelParams(0),
AudioConfig(0),
ProtectionLevels(0),
MSC_BER(0),
AudioCRCFails(0),
AudioMute(0),
ServiceQuality(0),
FAC_ERRS(0),
FAC_CRC_Fails(0),
SDC_ERRS(0),
SDC_CRC_Fails(0)
{

}

clCMDrmTestModeStatus::~clCMDrmTestModeStatus(){

}

tunerVector<unsigned char> clCMDrmTestModeStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMDrmTestModeStatus::u16GetSize(){

	return 0;
}

void clCMDrmTestModeStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position = 0;

	TunerInfo = bitStream[position++];

	Frequency = getInt(bitStream, position);
	position =(unsigned short)(position + sizeof(Frequency));

	FieldStrength = bitStream[position++];
	SyncStatus = bitStream[position++];
	RobustnessMode = bitStream[position++];

	ChannelParams = Construct3Bytes(bitStream, position);
	ConstructService(bitStream, position);
	
	//ServiceLabelData.Construct(bitStream, position);
	ConstructServiceLabelData(bitStream, position);

	AudioConfig = Construct3Bytes(bitStream, position);
	ProtectionLevels = bitStream[position++];

	MSC_BER = getInt(bitStream, position);
	position =(unsigned short)(position + sizeof(MSC_BER));

	AudioCRCFails = bitStream[position++];
	AudioMute = bitStream[position++];
	ServiceQuality = bitStream[position++];

	Construct_FAC_SDC(bitStream, position);
}

void clCMDrmTestModeStatus::ConstructServiceLabelData(tunerVector<unsigned char> bitStream, unsigned short &position)
{
	const short ServiceLabelDataValidBytesPosition = 64;
	unsigned char ServiceLabelDataLength = bitStream[position + ServiceLabelDataValidBytesPosition];
	if((int)ServiceLabelDataLength > ServiceLabelDataValidBytesPosition)
	{
		ServiceLabelDataLength = ServiceLabelDataValidBytesPosition;
	}
	tunerString oServiceLabelDataString ((const char *)&(bitStream[position]), ServiceLabelDataLength);
	ServiceLabelData = oServiceLabelDataString;
	position =(unsigned short)(position + ServiceLabelDataValidBytesPosition + 1);
}

void clCMDrmTestModeStatus::Construct_FAC_SDC(tunerVector<unsigned char> bitStream, unsigned short &position)
{
	unsigned char MSB = bitStream[position++];
	unsigned char LSB = bitStream[position++];
	FAC_ERRS = getWord(LSB, MSB);
	FAC_CRC_Fails = bitStream[position++];

	MSB = bitStream[position++];
	LSB = bitStream[position++];
	SDC_ERRS = getWord(LSB, MSB);
	SDC_CRC_Fails = bitStream[position++];
}


void clCMDrmTestModeStatus::ConstructService(tunerVector<unsigned char> bitStream, unsigned short &position)
{
	tunerVector<unsigned char>::iterator Start = bitStream.begin() + position;
	tunerVector<unsigned char>::iterator End = bitStream.begin() + position + SERVICE_LEN;

	//Service.insert(Service.begin(), Start, End);
	Service.assign(Start, End);
	position =(unsigned short)(position + SERVICE_LEN);
}
