///////////////////////////////////////////////////////////
//  clCMDrmTestModeSet.h
//  Implementation of the Class clCMDrmTestModeSet
//  Created on:      08-Jul-2015 7:08:10 PM
///////////////////////////////////////////////////////////

#if !defined(EA_78E714F3_CC75_4695_8229_76D8E42B670F__INCLUDED_)
#define EA_78E714F3_CC75_4695_8229_76D8E42B670F__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMDrmTestModeSet : public clADRMsgPayload
{

public:
	/**
	 * Enumeration 0..2
	 * 0 Testmode auto notifications are switched off
	 * 1 Testmode auto notifications are switched on
	 * 2 Testmode auto notifications are switched on for audio tuner
	 */
	clCMEnum_TestmodeActivity TestmodeActivity;

	clCMDrmTestModeSet();
	virtual ~clCMDrmTestModeSet();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set DrmTestModeSet parameters
	 */
	void setTestmodeActivity(clCMEnum_TestmodeActivity::enTestmodeActivity newTestmodeActivity);

};
#endif // !defined(EA_78E714F3_CC75_4695_8229_76D8E42B670F__INCLUDED_)
