///////////////////////////////////////////////////////////
//  clCMDemodulationSwitchSet.h
//  Implementation of the Class clCMDemodulationSwitchSet
//  Created on:      26-Feb-2015 12:14:40 PM
///////////////////////////////////////////////////////////

#if !defined(EA_51F77836_5CBC_4306_8FB4_122F5FD78F44__INCLUDED_)
#define EA_51F77836_5CBC_4306_8FB4_122F5FD78F44__INCLUDED_

#include "clADRMsgPayload.h"

class clCMDemodulationSwitchSet : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMDemodulationSwitchSet();
	/**
	 * Destructor
	 */
	virtual ~clCMDemodulationSwitchSet();
	/**
	 * Boolean (1 Byte)
	 * Bit 0 True FM and AM switch enabled
	 *      False FM and AM switch disabled
	 * Bit 1 True FM-HD switch enabled
	 *      False FM-HD switch disabled
	 * Bit 2 True AM-HD switch enabled
	 *      False AM-HD switch disabled
	 * Bit 3 True DRM30 disabled
	 *      False DRM30 enabled
	 * (4..7 reserved) reserved
	 */
	unsigned char DemodulationSwitches;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set demodulation switch
	 */
	void setDemodulationSwitch(unsigned char newDemodulationSwitch);

};
#endif // !defined(EA_51F77836_5CBC_4306_8FB4_122F5FD78F44__INCLUDED_)
