///////////////////////////////////////////////////////////
//  clCMDRMCurrentRadiotextStatus.h
//  Implementation of the Class clCMDRMCurrentRadiotextStatus
//  Created on:      29-May-2015 6:57:00 PM
///////////////////////////////////////////////////////////

#if !defined(EA_DCFB6FEA_06A9_4b50_83AC_5770A34BFF77__INCLUDED_)
#define EA_DCFB6FEA_06A9_4b50_83AC_5770A34BFF77__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"

class clCMDRMCurrentRadiotextStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned longword 0..0xffffffff
	 */
	unsigned int DRMServiceId;
	/**
	 * Unsigned byte 0 .. 128
	 */
	unsigned char NumberOfRadiotextBytes;
	/**
	 * Byte array
	 * 0..128, depending on 'NumberOfRadiotextBytes'
	 */
	tunerString RadiotextBytes;
	/**
	 * Unsigned byte 0 .. 128
	 */
	unsigned char NumberOfControlfieldBytes;
	/**
	 * Byte array
	 * 0..128, depending on 'NumberOfControlfieldBytes'
	 */
	tunerVector<unsigned char> ControlfieldBytes;

	clCMDRMCurrentRadiotextStatus();
	virtual ~clCMDRMCurrentRadiotextStatus();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set DRMCurrentRadiotextStatus parameters
	 */
	void setDRMServiceId(unsigned int newDRMServiceId);
	void setRadiotextBytes(tunerString newRadiotextBytes);
	void setControlfieldBytes(tunerVector<unsigned char> newControlfieldBytes);
	/**
	 * read DRMCurrentRadiotextStatus parameters
	 */
	unsigned int getDRMServiceId();
	unsigned char getNumberOfRadiotextBytes();
	unsigned char getNumberOfControlfieldBytes();
	tunerString getRadiotextBytes();
	tunerVector<unsigned char> getControlfieldBytes();

};
#endif // !defined(EA_DCFB6FEA_06A9_4b50_83AC_5770A34BFF77__INCLUDED_)
