///////////////////////////////////////////////////////////
//  clCMDRMCurrentRadiotextStatus.cpp
//  Implementation of the Class clCMDRMCurrentRadiotextStatus
//  Created on:      29-May-2015 6:57:00 PM
///////////////////////////////////////////////////////////

#include "clCMDRMCurrentRadiotextStatus.h"

#define RADIOTEXTBYTES_LEN 128

clCMDRMCurrentRadiotextStatus::clCMDRMCurrentRadiotextStatus() : DRMServiceId(0),
NumberOfRadiotextBytes(0),
NumberOfControlfieldBytes(0){

}

clCMDRMCurrentRadiotextStatus::~clCMDRMCurrentRadiotextStatus(){

}

tunerVector<unsigned char> clCMDRMCurrentRadiotextStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMDRMCurrentRadiotextStatus::u16GetSize(){

	return 0;
}

void clCMDRMCurrentRadiotextStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position = 0;

	DRMServiceId = getInt(bitStream, position);
	position =(unsigned short)(position + sizeof(DRMServiceId));

	NumberOfRadiotextBytes = bitStream[position++];
	if(bitStream.size() > (unsigned short)(position + NumberOfRadiotextBytes))
	{
		RadiotextBytes.assign ( (const char *)(&bitStream[position]), NumberOfRadiotextBytes );
		position =(unsigned short)(position + NumberOfRadiotextBytes);
	}
	if(bitStream.size() > position)
	{
		NumberOfControlfieldBytes = bitStream[position++];
	}

	if(bitStream.size() >=(unsigned short)(position + NumberOfControlfieldBytes))
	{
		ControlfieldBytes.assign(bitStream.begin() + position, bitStream.begin() + position + NumberOfControlfieldBytes);
		position =(unsigned short)(position + NumberOfControlfieldBytes);
	}
}

void clCMDRMCurrentRadiotextStatus::setDRMServiceId(unsigned int newDRMServiceId)
{
	DRMServiceId = newDRMServiceId;
}

void clCMDRMCurrentRadiotextStatus::setRadiotextBytes(tunerString newRadiotextBytes)
{
	unsigned short Strsize = (unsigned short)newRadiotextBytes.size();
	if(Strsize > RADIOTEXTBYTES_LEN)
	{
		Strsize = RADIOTEXTBYTES_LEN;
	}
	tunerString ostring(newRadiotextBytes.c_str(), Strsize);
	RadiotextBytes = ostring;
}

void clCMDRMCurrentRadiotextStatus::setControlfieldBytes(tunerVector<unsigned char> newControlfieldBytes)
{
	ControlfieldBytes.assign(newControlfieldBytes.begin(), newControlfieldBytes.end());
}

unsigned int clCMDRMCurrentRadiotextStatus::getDRMServiceId()
{
	return DRMServiceId;
}

unsigned char clCMDRMCurrentRadiotextStatus::getNumberOfRadiotextBytes()
{
	return NumberOfRadiotextBytes;
}

unsigned char clCMDRMCurrentRadiotextStatus::getNumberOfControlfieldBytes()
{
	return NumberOfControlfieldBytes;
}

tunerString clCMDRMCurrentRadiotextStatus::getRadiotextBytes()
{
	return RadiotextBytes;
}

tunerVector<unsigned char> clCMDRMCurrentRadiotextStatus::getControlfieldBytes()
{
	return ControlfieldBytes;
}
