///////////////////////////////////////////////////////////
//  clCMDRMAudioLogicalFrameStatus.h
//  Implementation of the Class clCMDRMAudioLogicalFrameStatus
//  Created on:      14-Jan-2015 15:55:41
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_F38C9508_F9D2_4f03_88D1_76D65EF5713D__INCLUDED_)
#define EA_F38C9508_F9D2_4f03_88D1_76D65EF5713D__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"
#include "types/clCMEnumTypes.h"

//#include "glib.h"
//#include "gst/gst.h"

class clCMDRMAudioLogicalFrameStatus : public clADRMsgPayload
{

public:
	clCMDRMAudioLogicalFrameStatus();
	virtual ~clCMDRMAudioLogicalFrameStatus();
	/**
	 * Enumeration Unsigned byte 0..3
	 */
	clCMEnum_AudioStreamType AudioStreamType;
	/**
	 * Enumeration Unsigned byte 0..2
	 */
	clCMEnum_Action Action;
	/**
	 * Unsigned long word 0...0xffffffff
	 */
	unsigned int FrameCntr;
	/**
	 * Enumeration Unsigned byte 0..2
	 */
	clCMEnum_NonReliabilityIndication NonReliabilityIndication;
	/**
	 * Unsigned byte 3..255
	 */
	unsigned char LenAudioInfoEntity;
	/**
	 * Bit field 3 + n bytes
	 */
	tunerVector<unsigned char> AudioInfoEntity;
	/**
	 * Unsigned byte 0..255
	 */
	unsigned char RfuByte_0;
	unsigned char RfuByte_1;
	unsigned char RfuByte_2;
	unsigned char RfuByte_3;
	unsigned char RfuByte_4;
	unsigned char RfuByte_5;
	unsigned char RfuByte_6;
	unsigned char RfuByte_7;
	unsigned char RfuByte_8;
	unsigned char RfuByte_9;
	unsigned char RfuByte_10;
	unsigned char RfuByte_11;
	unsigned char RfuByte_12;
	unsigned char RfuByte_13;
	unsigned char RfuByte_14;
	unsigned char RfuByte_15;
	unsigned char RfuByte_16;
	unsigned char RfuByte_17;
	/**
	 * Unsigned word 0..65535
	 */
	unsigned short LenHigherProtFrameData;
	/**
	 * Unsigned word 0..65535
	 */
	unsigned short LenFrameData;
	/**
	 * Unsigned byte LenFrameData bytes
	 */
	tunerVector<unsigned char> FrameData;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	void vConstructRFUBytes(tunerVector<unsigned char> bitStream, unsigned short &position);
	/**
	 * Set DRM AudioLogical Frame Status parameters
	 */
	void setAudioInfoEntity(tunerVector<unsigned char> newAudioInfoEntity);
	void setFrameData(tunerVector<unsigned char> newFrameData);
	/**
	 * Read DRM AudioLogical Frame Status parameters
	 */
	clCMEnum_AudioStreamType::enAudioStreamType getAudioStreamType();
	clCMEnum_Action::enAction getAction();
	unsigned int getFrameCntr();
	clCMEnum_NonReliabilityIndication::enNonReliabilityIndication getNonReliabilityIndication();
	unsigned char getLenAudioInfoEntity();
	tunerVector<unsigned char> getAudioInfoEntity();
	unsigned char getRfuByte_0();
	unsigned char getRfuByte_1();
	unsigned char getRfuByte_2();
	unsigned char getRfuByte_3();
	unsigned char getRfuByte_4();
	unsigned char getRfuByte_5();
	unsigned char getRfuByte_6();
	unsigned char getRfuByte_7();
	unsigned char getRfuByte_8();
	unsigned char getRfuByte_9();
	unsigned char getRfuByte_10();
	unsigned char getRfuByte_11();
	unsigned char getRfuByte_12();
	unsigned char getRfuByte_13();
	unsigned char getRfuByte_14();
	unsigned char getRfuByte_15();
	unsigned char getRfuByte_16();
	unsigned char getRfuByte_17();
	unsigned short getLenHigherProtFrameData();
	unsigned short getLenFrameData();
	tunerVector<unsigned char> getFrameData();

	void CalculateFrameDataLength();

};
#endif // !defined(EA_F38C9508_F9D2_4f03_88D1_76D65EF5713D__INCLUDED_)
