/******************************************************************
*FILE: clCMChangeOfSurveilledStations.h
*SW-COMPONENT: tuner
*DESCRIPTION:
*COPYRIGHT: © 2016 Robert Bosch GmbH
*AUTHOR:auj1kor
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef CLCMCHANGEOFSURVEILLEDSTATIONS_H_
#define CLCMCHANGEOFSURVEILLEDSTATIONS_H_

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"
#include "types/clCMEnumTypes.h"

class clCMChangeOfSurveilledStations : public clADRMsgPayload
{

public:
	clCMChangeOfSurveilledStations();
	virtual ~clCMChangeOfSurveilledStations();

	/**
	 * returns the size of the data stream
	 */
	virtual tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	virtual short u16GetSize();
	/**
	 *
	 * @param bitStream
	 */
	virtual void vConstruct(tunerVector<unsigned char> bitStream);

	unsigned char u8GetInvolvedModulations();


private :
	unsigned char m_u8InvolvedModulations;

};

#endif /* CLCMCHANGEOFSURVEILLEDSTATIONS_H_ */
