/******************************************************************
*FILE: clCMChangeOfSurveilledStations.cpp
*SW-COMPONENT: tuner
*DESCRIPTION:
*COPYRIGHT: © 2016 Robert Bosch GmbH
*AUTHOR:auj1kor
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/


#include "clCMChangeOfSurveilledStations.h"
#include "datatypes/tAlgorithm.h"

#include "tuner_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clCMChangeOfSurveilledStations.cpp.trc.h"
#endif

clCMChangeOfSurveilledStations::clCMChangeOfSurveilledStations()
{
	m_u8InvolvedModulations = 0;
}



clCMChangeOfSurveilledStations::~clCMChangeOfSurveilledStations()
{
	m_u8InvolvedModulations = 0;
}


tunerVector<unsigned char> clCMChangeOfSurveilledStations::oSerialize()
{

   tunerVector<unsigned char> payloadData;
   payloadData.push_back(m_u8InvolvedModulations);
   return payloadData;
}


short clCMChangeOfSurveilledStations::u16GetSize()
{

	return sizeof(m_u8InvolvedModulations);
}

unsigned char clCMChangeOfSurveilledStations::u8GetInvolvedModulations()
{

	return m_u8InvolvedModulations;
}

void clCMChangeOfSurveilledStations::vConstruct(tunerVector<unsigned char> bitStream)
{
   unsigned short index = 0;
   if (bitStream.size())
   {
	   m_u8InvolvedModulations = bitStream[index++];
   }
}


