/******************************************************************
*FILE: clCMChangeLsmSet.h
*SW-COMPONENT: tuner
*DESCRIPTION:
*COPYRIGHT: © 2016 Robert Bosch GmbH
*AUTHOR:auj1kor
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef CLCMCHANGELSMSET_H_
#define CLCMCHANGELSMSET_H_

#include "clADRMsgPayload.h"

class clCMChangeLsmSet : public clADRMsgPayload
{

private:

	unsigned char u8Option;
    unsigned char u8Band;
    unsigned int  u32Frequency;
    unsigned short u16PI;
    unsigned int u32HDStationID;
    unsigned int u32DRMServiceID;
    unsigned char u8HDAudioProgramNumber;
    unsigned char u8PresetListKey;
    unsigned short u16PresetList;

public:

    clCMChangeLsmSet();
    virtual ~clCMChangeLsmSet();
    /**
    * serialize the data stream
    */
    tunerVector<unsigned char> oSerialize();

    void setOption(unsigned char newOption);

    void setBand(unsigned char newBand);

    void setFrequency(unsigned int newFrequency);

    void setPI(unsigned short newPI);

    void setHDStationID(unsigned int newHDStationID);

    void setDRMServiceID(unsigned int newDRMServiceID);

    void setHDAudioProgramNumber(unsigned char newHDAudioProgramNumber);

    void setPresetListKey(unsigned char newPresetListKey);

    void setPresetList(unsigned short newPresetList);

    short u16GetSize();

    void vConstruct(tunerVector<unsigned char> bitStream);

};


#endif /* CLCMCHANGELSMSET_H_ */
