/******************************************************************
*FILE: clCMChangeLsmSet.cpp
*SW-COMPONENT: tuner
*DESCRIPTION:
*COPYRIGHT: © 2016 Robert Bosch GmbH
*AUTHOR:auj1kor
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/


#include "clCMChangeLsmSet.h"

clCMChangeLsmSet::clCMChangeLsmSet()
{
	u8Option = 0xFF;
	u8Band = 0xFF;
	u32Frequency = 0;
	u16PI = 0;
	u32HDStationID = 0;
	u32DRMServiceID = 0;
	u8HDAudioProgramNumber = 0;
	u8PresetListKey = 0;
	u16PresetList = 0;
}

clCMChangeLsmSet::~clCMChangeLsmSet()
{
	u8Option = 0xFF;
	u8Band = 0xFF;
	u32Frequency = 0;
	u16PI = 0;
	u32HDStationID = 0;
	u32DRMServiceID = 0;
	u8HDAudioProgramNumber = 0;
	u8PresetListKey = 0;
	u16PresetList = 0;
}

tunerVector<unsigned char> clCMChangeLsmSet::oSerialize(){

    tunerVector<unsigned char> payload;
    payload.push_back(u8Option);
    payload.push_back(u8Band);
    vAddInt(payload, u32Frequency);
    vAddShort(payload, u16PI);
    vAddInt(payload, u32HDStationID);
    payload.push_back(u8HDAudioProgramNumber);
    vAddInt(payload, u32DRMServiceID);
    vAddShort(payload, u16PresetList);
    payload.push_back(u8PresetListKey);
    return payload;
}

void clCMChangeLsmSet::setOption(unsigned char newOption)
{
	u8Option = newOption;
}

void clCMChangeLsmSet::setBand(unsigned char newBand)
{
	u8Band = newBand;
}

void clCMChangeLsmSet::setFrequency(unsigned int newFrequency)
{
    u32Frequency = newFrequency;
}

void clCMChangeLsmSet::setPI(unsigned short newPI)
{
	u16PI = newPI;
}

void clCMChangeLsmSet::setHDStationID(unsigned int newHDStationID)
{
	u32HDStationID = newHDStationID;
}

void clCMChangeLsmSet::setDRMServiceID(unsigned int newDRMServiceID)
{
	u32DRMServiceID = newDRMServiceID;
}

void clCMChangeLsmSet::setHDAudioProgramNumber(unsigned char newHDAudioProgramNumber)
{
	u8HDAudioProgramNumber = newHDAudioProgramNumber;
}

void clCMChangeLsmSet::setPresetListKey(unsigned char newPresetListKey)
{
	u8PresetListKey = newPresetListKey;
}

void clCMChangeLsmSet::setPresetList(unsigned short newPresetList)
{
	u16PresetList = newPresetList;
}

short clCMChangeLsmSet::u16GetSize()
{
    return (sizeof(u8Option) + sizeof(u8Band) + sizeof(u32Frequency) + sizeof(u16PI) + sizeof(u32HDStationID) + sizeof(u32DRMServiceID) + sizeof(u8HDAudioProgramNumber)
    		+ sizeof(u8PresetListKey) + sizeof(u16PresetList));
}

void clCMChangeLsmSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}


