///////////////////////////////////////////////////////////
//  clCMAutostore.h
//  Implementation of the Class clCMAutostore
//  Created on:      14-Jan-2015 10:12:18 AM
//  Original author: pmn3kor
///////////////////////////////////////////////////////////

#if !defined(EA_3D9601D1_5CB8_4e6a_95AA_F20929957F08__INCLUDED_)
#define EA_3D9601D1_5CB8_4e6a_95AA_F20929957F08__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"

/**
 * class contains autostore functionality related informations
 */
class clCMAutostore : public clADRMsgPayload
{

public:
	clCMAutostore();
	virtual ~clCMAutostore();

    unsigned short Getu16FunctionIdOfList();
	unsigned char Getu8BehaviouralSwitches();
	unsigned char Getu8MaxNumberOfStations();
	unsigned char Getu8SortingCriteria();
    unsigned char Getu8UnusedPresetTreatment();
    void Setu16FunctionIdOfList(unsigned short newVal);
	void Setu8BehaviouralSwitches(unsigned char newVal);
	void Setu8MaxNumberOfStations(unsigned char newVal);
	void Setu8SortingCriteria(unsigned char newVal);
    void Setu8UnusedPresetTreatment(unsigned char newVal);
	virtual short u16GetSize();
	virtual void vConstruct(tunerVector<unsigned char> bitStream);
    virtual tunerVector<unsigned char> oSerialize();

private:
	/**
	 * Preset list ID
	 */
	unsigned short u16FunctionIdOfList;
	unsigned char u8BehaviouralSwitches;
	/**
	 * contains the maximum number of stations which can be stored after autostore. 
	 */
	unsigned char u8MaxNumberOfStations;
	/**
	 * Configure the sorting criterion 
	 */
	unsigned char u8SortingCriteria;
	/**
	 * Configure what to do with the unused presets in the list 
	 */
    unsigned char u8UnusedPresetTreatment;

};
#endif // !defined(EA_3D9601D1_5CB8_4e6a_95AA_F20929957F08__INCLUDED_)

