///////////////////////////////////////////////////////////
//  clCMAnnouncementSwitchSet.h
//  Implementation of the Class clCMAnnouncementSwitchSet
//  Created on:      27-May-2015 4:44:07 PM
///////////////////////////////////////////////////////////

#if !defined(EA_7EF5B09F_EC19_49e6_ABD9_97CF3D6E7B60__INCLUDED_)
#define EA_7EF5B09F_EC19_49e6_ABD9_97CF3D6E7B60__INCLUDED_

#include "clADRMsgPayload.h"

class clCMAnnouncementSwitchSet : public clADRMsgPayload
{

public:
	/**
	 * Boolean(1 byte)
	 * Bit 0 True    TP On
	 *       False   TP Off
	 * Bit 1 True    PTY31 On
	 *       False   PTY31 Off
	 * (2..7 reserved)
	 */
	unsigned char Announcements;

	clCMAnnouncementSwitchSet();
	virtual ~clCMAnnouncementSwitchSet();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set AnnouncmentSwitchSet parameters
	 */
	void setAnnouncements(unsigned char newAnnouncements);
	void setTPOn();
	void setTPOff();
	void setPTY31On();
	void setPTY31Off();

};
#endif // !defined(EA_7EF5B09F_EC19_49e6_ABD9_97CF3D6E7B60__INCLUDED_)
