///////////////////////////////////////////////////////////
//  clCMAnnouncementMessageStatus.h
//  Implementation of the Class clCMAnnouncementMessageStatus
//  Created on:      27-May-2015 6:35:26 PM
///////////////////////////////////////////////////////////

#if !defined(EA_153789BF_FB7C_4b5e_9EDE_D782139CF1E7__INCLUDED_)
#define EA_153789BF_FB7C_4b5e_9EDE_D782139CF1E7__INCLUDED_

#include "clADRMsgPayload.h"

class clCMAnnouncementMessageStatus : public clADRMsgPayload
{

public:
	/**
	 * Boolean(1 byte)
	 * Bit 0 False TA not active
	 *       True  TA active
	 * Bit 1 False EON TA not active
	 *       True  EON TA active
	 * Bit 2 False PTY31 not active
	 *       True  PTY31 active
	 * Bit 3..7 False not used
	 *          True  not used
	 */
	unsigned char TAMessageInfo;

	clCMAnnouncementMessageStatus();
	virtual ~clCMAnnouncementMessageStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * read AnnouncmentMessageStatus parameters
	 */
	unsigned char getTAMessageInfo();
	bool getTA();
	bool getEONTA();
	bool getPTY31();

};
#endif // !defined(EA_153789BF_FB7C_4b5e_9EDE_D782139CF1E7__INCLUDED_)
