///////////////////////////////////////////////////////////
//  clCMAnnouncementInfoStatus.h
//  Implementation of the Class clCMAnnouncementInfoStatus
//  Created on:      28-May-2015 10:13:37 AM
///////////////////////////////////////////////////////////

#if !defined(EA_603718D0_980C_47ff_9126_96F4DDF3471F__INCLUDED_)
#define EA_603718D0_980C_47ff_9126_96F4DDF3471F__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tString.h"
#include "types/clCMEnumTypes.h"

class clCMAnnouncementInfoStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long 150..108000
	 */
	unsigned int Frequency;
	/**
	 * Unsigned word 0 ..0xffff
	 */
	unsigned short PI;
	/**
	 * String - 8 bytes size
	 */
	tunerString TaStationname;
	/**
	 * Enumeration 0..1
	 * 0 TP
	 * 1 PTY31
	 */
	clCMEnum_AnnouncementType AnnouncementType;

	clCMAnnouncementInfoStatus();
	virtual ~clCMAnnouncementInfoStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set AnnouncmentInfoStatus parameters
	 */
	void setFrequency(unsigned int newFrequency);
	void setPI(unsigned short newPI);
	void setTaStationname(tunerString newTaStationname);
	void setAnnouncementType(clCMEnum_AnnouncementType::enAnnouncementType newAnnouncementType);
	/**
	 * read AnnouncmentInfoStatus parameters
	 */
	unsigned int getFrequency();
	unsigned short getPI();
	const char * getTaStationname();
	clCMEnum_AnnouncementType::enAnnouncementType getAnnouncementType();

};
#endif // !defined(EA_603718D0_980C_47ff_9126_96F4DDF3471F__INCLUDED_)
