///////////////////////////////////////////////////////////
//  clCMAdditionalVersionInfoStatus.h
//  Implementation of the Class clCMAdditionalVersionInfoStatus
//  Created on:      05-Feb-2015 12:00:38 PM
///////////////////////////////////////////////////////////

#if !defined(EA_F1B6FD44_3D18_408c_925F_CCD4B8DA714A__INCLUDED_)
#define EA_F1B6FD44_3D18_408c_925F_CCD4B8DA714A__INCLUDED_

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"
#include "datatypes/tAlgorithm.h"

#define RFU_BYTES	14

class clCMAdditionalVersionInfoStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMAdditionalVersionInfoStatus();
	/**
	 * Destructor
	 */
	virtual ~clCMAdditionalVersionInfoStatus();
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short VersionNumber;
	/**
	 * Unsigned byte 0..0xff Reserved
	 */
	unsigned char FirstVersionDigit;
	unsigned char SecondVersionDigit;
	unsigned char ThirdVersionDigit;

	unsigned char rfu_byte_0;
	unsigned char rfu_byte_1;
	unsigned char rfu_byte_2;
	unsigned char rfu_byte_3;
	unsigned char rfu_byte_4;
	unsigned char rfu_byte_5;
	unsigned char rfu_byte_6;
	unsigned char rfu_byte_7;
	unsigned char rfu_byte_8;
	unsigned char rfu_byte_9;
	unsigned char rfu_byte_10;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Read version number
	 */
	unsigned short getVersionNumber() const;
	/**
	 * Read First Version digit
	 */
	unsigned char getFirstVersionDigit() const;
	/**
	 * Read Second Version digit
	 */
	unsigned char getSecondVersionDigit() const;
	/**
	 * Read Third Version digit
	 */
	unsigned char getThirdVersionDigit() const;
	/**
	 * Set version number
	 */
	void setVersionNumber(unsigned short newVersionNumber);
	/**
	 * Read RFU bytes
	 */
	tunerVector<unsigned char> getrfu_bytes();
	/**
	 * Set RFU bytes
	 */
	void setrfu_bytes(tunerVector<unsigned char> newrfu_bytes);

};
#endif // !defined(EA_F1B6FD44_3D18_408c_925F_CCD4B8DA714A__INCLUDED_)
