///////////////////////////////////////////////////////////
//  clCMActivePreset_h.h
//  Implementation of the Class clCMActivePreset
//  Created on:      12-Jan-2015 14:47:42
//  Original author: pad1cob
///////////////////////////////////////////////////////////
#ifndef clCMActivePreset_h
#define clCMActivePreset_h

#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"

/**
 * Class used to contain information related to the Active Preset function
 * @author pad1cob
 * @version 1.0
 * @created 13-Jan-2015 14:47:42
 */
class clCMActivePreset : public clADRMsgPayload
{

public:
	clCMActivePreset();
	virtual ~clCMActivePreset();

	/**
	 * Return : short
	 * @param None
	 */
	short getu16ListID();

	/**
	 * returns the size of the data stream
	 */
	virtual tunerVector<unsigned char> oSerialize();
	/**
	 *
	 * @param newVal
	 */
	void setu16ListID(short newVal);

	/**
	 * returns the size of the payload
	 */
	virtual short u16GetSize();
	/**
	 * 
	 * @param bitStream
	 */
	virtual void vConstruct(tunerVector<unsigned char> bitStream);

private:
	/**
	 * The e8ListID as defined in ADR spec
	 */

	short u16ListID;

};
#endif
