///////////////////////////////////////////////////////////
//  clCMATTunerStateStatus.h
//  Implementation of the Class clCMATTunerStateStatus
//  Created on:      14-May-2015 12:23:01 PM
///////////////////////////////////////////////////////////

#if !defined(EA_8A5BE963_68E2_4d47_9426_6B54A83D6B11__INCLUDED_)
#define EA_8A5BE963_68E2_4d47_9426_6B54A83D6B11__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATTunerStateStatus : public clADRMsgPayload
{

public:
	/**
	 * Enumeration 0..18
	 */
	clCMEnum_Band Band;
	/**
	 * Enumeration 0..2
	 */
	clCMEnum_TuningState TuningState;
	/**
	 * Unsigned word 0..4096
	 */
	unsigned short FunctionId;

	clCMATTunerStateStatus();
	virtual ~clCMATTunerStateStatus();
	/**
	 * serialize the payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * construct the payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set TuningStateStatus parameters
	 */
	void setBand(clCMEnum_Band::enBand newBand);
	void setTuningState(clCMEnum_TuningState::enTuningState newTuningState);
	void setFunctionId(unsigned short newFunctionId);
	/**
	 * read TuningStateStatus parameters
	 */
	clCMEnum_Band::enBand getBand();
	clCMEnum_TuningState::enTuningState getTuningState();
	unsigned short getFunctionId();
};

#endif // !defined(EA_8A5BE963_68E2_4d47_9426_6B54A83D6B11__INCLUDED_)
