///////////////////////////////////////////////////////////
//  clCMATTunerStateStatus.cpp
//  Implementation of the Class clCMATTunerStateStatus
//  Created on:      14-May-2015 12:23:01 PM
///////////////////////////////////////////////////////////

#include "clCMATTunerStateStatus.h"

clCMATTunerStateStatus::clCMATTunerStateStatus() : FunctionId(0){

}

clCMATTunerStateStatus::~clCMATTunerStateStatus(){

}

tunerVector<unsigned char> clCMATTunerStateStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMATTunerStateStatus::u16GetSize(){

	return 0;
}

void clCMATTunerStateStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position = 0;

	Band.enType = static_cast<clCMEnum_Band::enBand>(bitStream[position++]);
	TuningState.enType = static_cast<clCMEnum_TuningState::enTuningState>(bitStream[position++]);
	unsigned char MSB = bitStream[position++];
	unsigned char LSB = bitStream[position++];
	FunctionId = getWord(LSB, MSB);
}

void clCMATTunerStateStatus::setBand(clCMEnum_Band::enBand newBand)
{
	Band.enType = newBand;
}

void clCMATTunerStateStatus::setTuningState(clCMEnum_TuningState::enTuningState newTuningState)
{
	TuningState.enType = newTuningState;
}

void clCMATTunerStateStatus::setFunctionId(unsigned short newFunctionId)
{
	FunctionId = newFunctionId;
}

clCMEnum_Band::enBand clCMATTunerStateStatus::getBand()
{
	return Band.enType;
}

clCMEnum_TuningState::enTuningState clCMATTunerStateStatus::getTuningState()
{
	return TuningState.enType;
}

unsigned short clCMATTunerStateStatus::getFunctionId()
{
	return FunctionId;
}
