///////////////////////////////////////////////////////////
//  clCMATPresetSave.cpp
//  Implementation of the Class clCMATPresetSave
//  Created on:      14-Jan-2015 5:12:46 PM
//  Original author: pmn3kor
///////////////////////////////////////////////////////////

#include "clCMATPresetSave.h"
#include "datatypes/tAlgorithm.h"

clCMATPresetSave::clCMATPresetSave(){
	u16FktId = 0xf020;
	u8PresetNumber = 1;
}



clCMATPresetSave::~clCMATPresetSave(){

}


/**
 * saves the current station on the given preset list. 
 */
unsigned short clCMATPresetSave::Getu16FktId(){

	return u16FktId;
}


/**
 * saves the current station on the given key of the given preset list 
 */
unsigned char clCMATPresetSave::Getu8PresetNumber(){

	return u8PresetNumber;
}


/**
 * returns the size of the data stream
 */
tunerVector<unsigned char> clCMATPresetSave::oSerialize(){

	tunerVector<unsigned char> payloadData;
	payloadData.push_back(getMSB(u16FktId));
	payloadData.push_back(getLSB(u16FktId));
	payloadData.push_back(u8PresetNumber);
	return payloadData;
}


/**
 * saves the current station on the given preset list. 
 */
void clCMATPresetSave::Setu16FktId(unsigned short newVal){

	u16FktId = newVal;
}


/**
 * saves the current station on the given key of the given preset list 
 */
void clCMATPresetSave::Setu8PresetNumber(unsigned char newVal){

	u8PresetNumber = newVal;
}


/**
 * returns the size of the payload
 */
short clCMATPresetSave::u16GetSize(){

	return (sizeof(u16FktId) + sizeof(u8PresetNumber));
}


void clCMATPresetSave::vConstruct(tunerVector<unsigned char> bitStream){

   short index = 0;
   unsigned char MSB = bitStream[index++];
   unsigned char LSB = bitStream[index++];
   u16FktId = getWord(LSB, MSB);
   u8PresetNumber = bitStream[index++];
}
