///////////////////////////////////////////////////////////
//  clCMATPresetList_XX.cpp
//  Implementation of the Class clCMATPresetList_XX
//  Created on:      14-Jan-2015 5:39:26 PM
//  Original author: pmn3kor
///////////////////////////////////////////////////////////

#include "clCMATPresetList_XX.h"
#include "datatypes/tAlgorithm.h"

#define PRESETSELECTION    1
#define FREQUENCY          2
#define SENDERNAME         3
#define PI_INFO            4
#define STATIONNAMEINFO    5
#define TPTMCTINFO         6
#define PTY_INFO           7
#define LEVELCOMPENSATION  8
#define DIGITALMODULATION  9
#define HDSTATIONID        10
#define STATIONNAMELENGTH  11
#define HDCALLSIGN         12
#define HDTEXTENCODING     13
#define HDSTATIONGENRE     14
#define HDPROGRAMNUMBER    15

#define SENDERNAME_LEN     8
#define SERVICELABEL_LEN   64


clCMATPresetList_XX::clCMATPresetList_XX(unsigned short presetListSize){
   for (unsigned short index = 0; index < presetListSize; index++)
   {
      clCMATPresetList_Data ListData;
      Data.push_back(ListData);
   }
}


clCMATPresetList_XX::clCMATPresetList_XX()
{

}

clCMATPresetList_XX::~clCMATPresetList_XX(){

}

bool clCMATPresetList_XX::bIsStaticSize()
{
	return false;
}


/**
 * returns the size of the data stream
 */
tunerVector<unsigned char> clCMATPresetList_XX::oSerialize(){

	tunerVector<unsigned char> payloadData;
	payloadData.push_back(Pos.x);
	payloadData.push_back(Pos.y);
    vSerializeData(payloadData);
    unsigned short payloadDataSize = (unsigned short)payloadData.size();
    payloadData.insert(payloadData.begin(), getLSB(payloadDataSize));
    payloadData.insert(payloadData.begin(), getMSB(payloadDataSize));
	return payloadData;
}


/**
 * returns the size of the payload
 */
short clCMATPresetList_XX::u16GetSize(){

   return 0; // dynamic content size determined by data content.. so return 0
}



void clCMATPresetList_XX::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position = 0;
	Pos.x = bitStream[position++];
	Pos.y = bitStream[position++];

	//construct data only if entire list is received
	if(bIsAllValuesSent() == true && bIsAllElementsSent() == true)
	{
		vConstructData(bitStream, position);
	}
  
}


void clCMATPresetList_XX::vConstructData(tunerVector<unsigned char>& bitStream, unsigned short& position)
{
	//if (bIsAllValuesSent())
	{
		vConstructAllValues(bitStream, position);
	}
	//else
	//{
		//vConstructSelectedValues(bitStream, position);
	//}
}


bool clCMATPresetList_XX::bIsAllValuesSent() {

	if (Pos.y == 0 )
	{
		return true;
	}
	return false;
}


void clCMATPresetList_XX::vConstructAllValues(tunerVector<unsigned char>& bitStream, unsigned short& position)
{
   //these lines are temporarily commented till CMG3GB-2051 is solved
	//if (bIsAllElementsSent())
	{
		for (unsigned short index = 1; index <= Data.size(); index++)
		{
			vConstructRow(bitStream, index, position);
		}
	}
	//else
	{
		//vConstructRow(bitStream, Pos.x, position);
	}
}


bool clCMATPresetList_XX::bIsAllElementsSent(){

   if (Pos.x == 0)
   {
      return true;
   }
   return false;
}


void clCMATPresetList_XX::vConstructSelectedValues(tunerVector<unsigned char>& bitStream, unsigned short& position)
{
	   if (bIsAllElementsSent())
	   {
	      for (unsigned short index = 1; index <= Data.size(); index++)
	      {
	         vConstructColumn(bitStream, index, Pos.y, position);
	      }
	   }
	   else
	   {
		   vConstructColumn(bitStream, Pos.x, Pos.y, position);
	   }
}


void clCMATPresetList_XX::vConstructRow(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short& position) {

	unsigned char TotalBytesInElement = Data[index-1].NumberOfBytesInElement = bitStream[position++];
	vConstructPresetSelection(bitStream, index, PRESETSELECTION, position);
	vConstructFrequency(bitStream, index, FREQUENCY, position);
	vConstructSenderName(bitStream, index, SENDERNAME, position);
	vConstructPI(bitStream, index, PI_INFO, position);
	vConstructStationNameInfo(bitStream, index, STATIONNAMEINFO, position);
	vConstructTPTMCInfo(bitStream, index, TPTMCTINFO, position);
	vConstructPTY(bitStream, index, PTY_INFO, position);
	vConstructLevelCompensation(bitStream, index, LEVELCOMPENSATION, position);

	vConstructDigitalModulation(bitStream, index, DIGITALMODULATION, position);
	vConstructHDStationID(bitStream, index, HDSTATIONID, position);
	vConstructStationNameLength(bitStream, index, STATIONNAMELENGTH, position);
	vConstructHDCallSign(bitStream, index, HDCALLSIGN, position);
	vConstructHDTextEncoding(bitStream, index, HDTEXTENCODING, position);
	vConstructHDStationGenre(bitStream, index, HDSTATIONGENRE, position);
	vConstructHDProgramNumber(bitStream, index,HDPROGRAMNUMBER,  position);

	Data[index-1].NumberOfBytesInElement = TotalBytesInElement;
}



void clCMATPresetList_XX::vConstructColumn(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	unsigned char TotalBytesInElement = Data[index-1].NumberOfBytesInElement = bitStream[position++];
	vConstructPresetSelection(bitStream, index, column, position);
	vConstructFrequency(bitStream, index, column, position);
	vConstructSenderName(bitStream, index, column, position);
	vConstructPI(bitStream, index, column, position);
	vConstructStationNameInfo(bitStream, index, column, position);
	vConstructTPTMCInfo(bitStream, index, column, position);
	vConstructPTY(bitStream, index, column, position);
	vConstructLevelCompensation(bitStream, index, column, position);

	vConstructDigitalModulation(bitStream, index, column, position);
	vConstructHDStationID(bitStream, index, column, position);
	vConstructStationNameLength(bitStream, index, column, position);
	vConstructHDCallSign(bitStream, index, column, position);
	vConstructHDTextEncoding(bitStream, index, column, position);
	vConstructHDStationGenre(bitStream, index, column, position);
	vConstructHDProgramNumber(bitStream, index, column, position);

	Data[index-1].NumberOfBytesInElement = TotalBytesInElement;
}


void clCMATPresetList_XX::vConstructPresetSelection(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == PRESETSELECTION && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].PresetSelection)){
		Data[index].PresetSelection = (unsigned char)bitStream[position++];
		Data[index].NumberOfBytesInElement = (unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].PresetSelection));
	}

}


void clCMATPresetList_XX::vConstructFrequency(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == FREQUENCY && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].Frequency)){
		Data[index].Frequency =getInt(bitStream, position);
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].Frequency));
		position =(unsigned short)(position + sizeof(Data[index].Frequency));
	}

}


void clCMATPresetList_XX::vConstructSenderName(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == SENDERNAME && (int)Data[index].NumberOfBytesInElement >= SENDERNAME_LEN){
		tunerString oSendernameString ((const char *)&(bitStream[position]), SENDERNAME_LEN);
		Data[index].Sendername = oSendernameString;
		Data[index].NumberOfBytesInElement = (unsigned char)(Data[index].NumberOfBytesInElement - SENDERNAME_LEN);
		position =(unsigned short)(position + SENDERNAME_LEN);
	}

}


void clCMATPresetList_XX::vConstructPI(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == PI_INFO && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].PI)){
		unsigned char MSB = bitStream[position++];
		unsigned char LSB = bitStream[position++];
		Data[index].PI  =getWord(LSB, MSB);
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].PI));
	}

}


void clCMATPresetList_XX::vConstructStationNameInfo(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == STATIONNAMEINFO && (int)Data[index].NumberOfBytesInElement >= Data[index].StationNameInfo.getSize()){
		Data[index].StationNameInfo.enType = static_cast<clCMEnum_StationNameInfo::enStationNameInfo>(bitStream[position++]);
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - Data[index].StationNameInfo.getSize());
	}

}


void clCMATPresetList_XX::vConstructTPTMCInfo(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == TPTMCTINFO && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].TpTmcInfo)){
		Data[index].TpTmcInfo =bitStream[position++];
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].TpTmcInfo));
	}

}


void clCMATPresetList_XX::vConstructPTY(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == PTY_INFO && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].PTY)){
		Data[index].PTY =bitStream[position++];
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].PTY));
	}

}


void clCMATPresetList_XX::vConstructLevelCompensation(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == LEVELCOMPENSATION && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].LevelCompensation)){
		Data[index].LevelCompensation =bitStream[position++];
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].LevelCompensation));
	}

}


void clCMATPresetList_XX::vConstructDigitalModulation(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == DIGITALMODULATION && (int)Data[index].NumberOfBytesInElement >= Data[index].DigitalModulation.getSize()){
		Data[index].DigitalModulation.enType = static_cast<clCMEnum_DigitalModulation::enDigitalModulation>(bitStream[position++]);
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - Data[index].DigitalModulation.getSize());
	}

}


void clCMATPresetList_XX::vConstructHDStationID(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == HDSTATIONID && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].HDStationID_DRMServiceID)){
		Data[index].HDStationID_DRMServiceID =getInt(bitStream, position);
		position =(unsigned short)(position + sizeof(Data[index].HDStationID_DRMServiceID));
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].HDStationID_DRMServiceID));
	}

}

void clCMATPresetList_XX::vConstructStationNameLength(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position)
{
	index--;
	if(column == STATIONNAMELENGTH && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].StationNameLength)){
		Data[index].StationNameLength =bitStream[position++];
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].StationNameLength));
	}
}

void clCMATPresetList_XX::vConstructHDCallSign(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	unsigned char size = Data[index].StationNameLength;
	if(column == HDCALLSIGN && (int)Data[index].NumberOfBytesInElement >= (int)size){
		Data[index].HDCallSign_DRMServiceLabel.clear();
		if((int)size > 0)
		{
			Data[index].HDCallSign_DRMServiceLabel.assign ( (const char *)(&bitStream[position]),size );
			position =(unsigned short)(position + size);
			Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - size);
		}
	}

}


void clCMATPresetList_XX::vConstructHDTextEncoding(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == HDTEXTENCODING && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].HDTextEncoding)){
		Data[index].HDTextEncoding =bitStream[position++];
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].HDTextEncoding));
	}

}


void clCMATPresetList_XX::vConstructHDStationGenre(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == HDSTATIONGENRE && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].HDStationGenre_DRMPty)){
		Data[index].HDStationGenre_DRMPty =bitStream[position++];
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].HDStationGenre_DRMPty));
	}

}


void clCMATPresetList_XX::vConstructHDProgramNumber(tunerVector<unsigned char>& bitStream, unsigned short index, unsigned short column, unsigned short& position) {

	index--;
	if(column == HDPROGRAMNUMBER && (int)Data[index].NumberOfBytesInElement >= sizeof(Data[index].HDProgramNumber_DRMServiceShortId)){
		Data[index].HDProgramNumber_DRMServiceShortId =bitStream[position++];
		Data[index].NumberOfBytesInElement =(unsigned char)(Data[index].NumberOfBytesInElement - sizeof(Data[index].HDProgramNumber_DRMServiceShortId));
	}

}


void clCMATPresetList_XX::vSerializeData(tunerVector<unsigned char>& payload){

   if (bIsAllValuesRequested())
   {
      vSerializeAllValues(payload);
   }
   else
   {
      vSerializeSelectedValues(payload);
   }
}


bool clCMATPresetList_XX::bIsAllValuesRequested(){

   if (Pos.y == 0 )
   {
      return true;
   }
   return false;
}


void clCMATPresetList_XX::vSerializeAllValues(tunerVector<unsigned char>& payload){

	unsigned char ListStartIndex = (unsigned char)payload.size();
   if (bIsAllElementsRequested())
   {
      for (unsigned short index = 1; index <= Data.size(); index++)
      {
			vSerializeRow(payload, index, ListStartIndex);
      }
   }
   else
   {
		vSerializeRow(payload, Pos.x, ListStartIndex);
   }
}


bool clCMATPresetList_XX::bIsAllElementsRequested(){

   if (Pos.x == 0)
   {
      return true;
   }
   return false;
}


void clCMATPresetList_XX::vSerializeSelectedValues(tunerVector<unsigned char>& payload){

	unsigned char ListStartIndex = (unsigned char)payload.size();
   if (bIsAllElementsRequested())
   {
      for (unsigned short index = 1; index <= Data.size(); index++)
      {
			vSerializeColumn(payload, index, Pos.y, ListStartIndex);
      }
   }
   else
   {
		vSerializeColumn(payload, Pos.x, Pos.y, ListStartIndex);
   }
}


void clCMATPresetList_XX::vSerializeRow(tunerVector<unsigned char>& payload, unsigned short index, unsigned char& ListStartIndex){

	payload.push_back(getData(index).NumberOfBytesInElement);
   	vSerializePresetSelection(payload, index, PRESETSELECTION);
	vSerializeFrequency(payload, index, FREQUENCY);
	vSerializeSenderName(payload, index, SENDERNAME);
	vSerializePI(payload, index, PI_INFO);
	vSerializeStationNameInfo(payload, index, STATIONNAMEINFO);
	vSerializeTPTMCInfo(payload, index, TPTMCTINFO);
	vSerializePTY(payload, index, PTY_INFO);
	vSerializeLevelCompensation(payload, index, LEVELCOMPENSATION);

	vSerializeDigitalModulation(payload, index, DIGITALMODULATION);
	vSerializeHDStationID(payload, index, HDSTATIONID);
	vSerializeStationNameLength(payload, index, STATIONNAMELENGTH);
	vSerializeHDCallSign(payload, index, HDCALLSIGN);
	vSerializeHDTextEncoding(payload, index, HDTEXTENCODING);
	vSerializeHDStationGenre(payload, index, HDSTATIONGENRE);
	vSerializeHDProgramNumber(payload, index, HDPROGRAMNUMBER);
	
	payload[ListStartIndex] = getData(index).NumberOfBytesInElement;
	ListStartIndex = (unsigned char)payload.size();
}


void clCMATPresetList_XX::vSerializeColumn(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column, unsigned char& ListStartIndex){

	payload.push_back(getData(index).NumberOfBytesInElement);

	vSerializePresetSelection(payload, index, column);
	vSerializeFrequency(payload, index, column);
	vSerializeSenderName(payload, index, column);
	vSerializePI(payload, index, column);
	vSerializeStationNameInfo(payload, index, column);
	vSerializeTPTMCInfo(payload, index, column);
	vSerializePTY(payload, index, column);
	vSerializeLevelCompensation(payload, index, column);

	vSerializeDigitalModulation(payload, index, column);
	vSerializeHDStationID(payload, index, column);
	vSerializeStationNameLength(payload, index, column);
	vSerializeHDCallSign(payload, index, column);
	vSerializeHDTextEncoding(payload, index, column);
	vSerializeHDStationGenre(payload, index, column);
	vSerializeHDProgramNumber(payload, index, column);
	
	payload[ListStartIndex] = getData(index).NumberOfBytesInElement;
	ListStartIndex = (unsigned char)payload.size();
}


void clCMATPresetList_XX::vSerializePresetSelection(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == PRESETSELECTION){
		payload.push_back(getData(index).PresetSelection);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).PresetSelection));
	}

}


void clCMATPresetList_XX::vSerializeFrequency(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == FREQUENCY){
		vAddInt(payload, getData(index).Frequency);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).Frequency));
	}

}


void clCMATPresetList_XX::vSerializeSenderName(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == SENDERNAME){
		int sendernamelength = (getData(index).Sendername.size() > SENDERNAME_LEN)?SENDERNAME_LEN:(int)getData(index).Sendername.size();
		int count = 0;
		for(; count < sendernamelength; count++)
		{
			payload.push_back(getData(index).Sendername[count]);
		}
		if(count < SENDERNAME_LEN){
			for(; count < SENDERNAME_LEN; count++)
			{
				payload.push_back((unsigned char)0);
			}
		}
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + SENDERNAME_LEN);
	}

}


void clCMATPresetList_XX::vSerializePI(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == PI_INFO){
		payload.push_back(getMSB(getData(index).PI));
		payload.push_back(getLSB(getData(index).PI));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).PI));
	}

}


void clCMATPresetList_XX::vSerializeStationNameInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == STATIONNAMEINFO){
		payload.push_back(static_cast<unsigned char>(getData(index).StationNameInfo.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).StationNameInfo.getSize());
	}

}


void clCMATPresetList_XX::vSerializeTPTMCInfo(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == TPTMCTINFO){
		payload.push_back(getData(index).TpTmcInfo);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).TpTmcInfo));
	}

}


void clCMATPresetList_XX::vSerializePTY(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == PTY_INFO){
		payload.push_back(getData(index).PTY);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).PTY));
	}

}


void clCMATPresetList_XX::vSerializeLevelCompensation(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == LEVELCOMPENSATION){
		payload.push_back(getData(index).LevelCompensation);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).LevelCompensation));
	}

}


void clCMATPresetList_XX::vSerializeDigitalModulation(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == DIGITALMODULATION){
		payload.push_back(static_cast<unsigned char>(getData(index).DigitalModulation.enType));
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + getData(index).DigitalModulation.getSize());
	}

}


void clCMATPresetList_XX::vSerializeHDStationID(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == HDSTATIONID){
		vAddInt(payload, getData(index).HDStationID_DRMServiceID);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).HDStationID_DRMServiceID));
	}

}

void clCMATPresetList_XX::vSerializeStationNameLength(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column)
{
	if(column == STATIONNAMELENGTH)
	{
		payload.push_back(getData(index).StationNameLength);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).StationNameLength));
	}
}

void clCMATPresetList_XX::vSerializeHDCallSign(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	int stationnamelength = (getData(index).StationNameLength > SERVICELABEL_LEN) ? SERVICELABEL_LEN : getData(index).StationNameLength;

	if(column == HDCALLSIGN){
		int count = 0;
		for(; count < stationnamelength && count < (int)getData(index).HDCallSign_DRMServiceLabel.size(); count++)
		{
			payload.push_back(getData(index).HDCallSign_DRMServiceLabel[count]);
		}
		if(count < SERVICELABEL_LEN)
		{
			for(; count < SERVICELABEL_LEN; count++)
			{
				payload.push_back((unsigned char)0);
			}
		}
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + SERVICELABEL_LEN);
	}

}


void clCMATPresetList_XX::vSerializeHDTextEncoding(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == HDTEXTENCODING){
		payload.push_back(getData(index).HDTextEncoding);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).HDTextEncoding));
	}

}


void clCMATPresetList_XX::vSerializeHDStationGenre(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == HDSTATIONGENRE){
		payload.push_back(getData(index).HDStationGenre_DRMPty);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).HDStationGenre_DRMPty));
	}

}


void clCMATPresetList_XX::vSerializeHDProgramNumber(tunerVector<unsigned char>& payload, unsigned short index, unsigned char column){

	if(column == HDPROGRAMNUMBER){
		payload.push_back(getData(index).HDProgramNumber_DRMServiceShortId);
		getData(index).NumberOfBytesInElement =(unsigned char)(getData(index).NumberOfBytesInElement + sizeof(getData(index).HDProgramNumber_DRMServiceShortId));
	}

}
