///////////////////////////////////////////////////////////
//  clCMATPresetList.cpp
//  Implementation of the Class clCMATPresetList
//  Created on:      14-Jan-2015 5:39:26 PM
//  Original author: pmn3kor
///////////////////////////////////////////////////////////

#include "clCMATPresetList.h"
#include "datatypes/tAlgorithm.h"

clCMATPresetList::clCMATPresetList(){
	PosX = 0;
	PosY = 0;
}



clCMATPresetList::~clCMATPresetList(){

}





/**
 * Valid range: x=0..Number of presets in list
 */
unsigned char clCMATPresetList::GetPosX(){

	return PosX;
}


/**
 * Valid range : y=0..8 
 */
unsigned char clCMATPresetList::GetPosY(){

	return PosY;
}


/**
 * returns the size of the data stream
 */
tunerVector<unsigned char> clCMATPresetList::oSerialize(){

	tunerVector<unsigned char> payloadData;
	payloadData.push_back(PosX);
	payloadData.push_back(PosY);
	return payloadData;
}


/**
 * Valid range: x=0..Number of presets in list
 */
void clCMATPresetList::SetPosX(unsigned char newVal){

	PosX = newVal;
}


/**
 * Valid range : y=0..8 
 */
void clCMATPresetList::SetPosY(unsigned char newVal){

	PosY = newVal;
}


/**
 * returns the size of the payload
 */
short clCMATPresetList::u16GetSize(){

	return (sizeof(PosX) + sizeof(PosY));
}


void clCMATPresetList::vConstruct(tunerVector<unsigned char> bitStream){

   unsigned short index = 0;
	if ((short)bitStream.size() == u16GetSize())
	{
       PosX = bitStream[index++];
       PosY = bitStream[index++];
	}
}
