///////////////////////////////////////////////////////////
//  clCMATLsmSetupStatus.cpp
//  Implementation of the Class clCMATLsmSetupStatus
//  Created on:      14-Apr-2015 6:22:28 PM
///////////////////////////////////////////////////////////

#include "clCMATLsmSetupStatus.h"

clCMATLsmSetupStatus::clCMATLsmSetupStatus() :
Frequency(0),
PI(0),
HDStationId_DRMServiceId(0),
RFU_byte_0(0),
RFU_byte_1(0),
RFU_byte_2(0),
RFU_byte_3(0) {

}


clCMATLsmSetupStatus::~clCMATLsmSetupStatus(){

}

tunerVector<unsigned char> clCMATLsmSetupStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMATLsmSetupStatus::u16GetSize(){

	return 0;
}

void clCMATLsmSetupStatus::vConstruct(tunerVector<unsigned char> bitStream){

	short pos = 0;

	Band.enType = static_cast<clCMEnum_Band::enBand>(bitStream[pos++]);
	Frequency = getInt(bitStream, pos);
	pos = (short)(pos + sizeof(Frequency));
	unsigned char MSB = bitStream[pos++];
	unsigned char LSB = bitStream[pos++];
	PI = getWord(LSB, MSB);
	HDStationId_DRMServiceId = getInt(bitStream, pos);
	pos = (short)(pos + sizeof(HDStationId_DRMServiceId));
	ModulationType.enType = static_cast<clCMEnum_ModulationType::enModulationType>(bitStream[pos++]);
	RFU_byte_0 = bitStream[pos++];
	RFU_byte_1 = bitStream[pos++];
	RFU_byte_2 = bitStream[pos++];
	RFU_byte_3 = bitStream[pos++];
}

void clCMATLsmSetupStatus::setBand(clCMEnum_Band::enBand newBand){

	Band.enType = newBand;
}

void clCMATLsmSetupStatus::setFrequency(unsigned int newFrequency){

	Frequency = newFrequency;
}

void clCMATLsmSetupStatus::setPI(unsigned short newPI){

	PI = newPI;
}

void clCMATLsmSetupStatus::setHDStationId_DRMServiceId(unsigned int newHDStationId_DRMServiceId){

	HDStationId_DRMServiceId = newHDStationId_DRMServiceId;
}

void clCMATLsmSetupStatus::setModulationType(clCMEnum_ModulationType::enModulationType newModulationType){

	ModulationType.enType = newModulationType;
}

void clCMATLsmSetupStatus::setRFU_byte_0(unsigned char newRFU_byte_0){

	RFU_byte_0 = newRFU_byte_0;
}

void clCMATLsmSetupStatus::setRFU_byte_1(unsigned char newRFU_byte_1){

	RFU_byte_1 = newRFU_byte_1;
}

void clCMATLsmSetupStatus::setRFU_byte_2(unsigned char newRFU_byte_2){

	RFU_byte_2 = newRFU_byte_2;
}

void clCMATLsmSetupStatus::setRFU_byte_3(unsigned char newRFU_byte_3){

	RFU_byte_3 = newRFU_byte_3;
}

clCMEnum_Band::enBand clCMATLsmSetupStatus::getBand(){

	return Band.enType;
}

unsigned int clCMATLsmSetupStatus::getFrequency(){

	return Frequency;
}

unsigned short clCMATLsmSetupStatus::getPI(){

	return PI;
}

unsigned int clCMATLsmSetupStatus::getHDStationId_DRMServiceId(){

	return HDStationId_DRMServiceId;
}

clCMEnum_ModulationType::enModulationType clCMATLsmSetupStatus::getModulationType(){

	return ModulationType.enType;
}

unsigned char clCMATLsmSetupStatus::getRFU_byte_0(){

	return RFU_byte_0;
}

unsigned char clCMATLsmSetupStatus::getRFU_byte_1(){

	return RFU_byte_1;
}

unsigned char clCMATLsmSetupStatus::getRFU_byte_2(){

	return RFU_byte_2;
}

unsigned char clCMATLsmSetupStatus::getRFU_byte_3(){

	return RFU_byte_3;
}
