///////////////////////////////////////////////////////////
//  clCMATLsmSetupSet.h
//  Implementation of the Class clCMATLsmSetupSet
//  Created on:      14-Apr-2015 6:22:28 PM
///////////////////////////////////////////////////////////

#if !defined(EA_E771496A_8B04_42b1_9EE1_08BE8A587278__INCLUDED_)
#define EA_E771496A_8B04_42b1_9EE1_08BE8A587278__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATLsmSetupSet : public clADRMsgPayload
{

public:
	clCMATLsmSetupSet();
	virtual ~clCMATLsmSetupSet();
	/**
	 * Enumeration 0..18 And 0xff
	 */
	clCMEnum_Band Band;
	/**
	 * Unsigned long 150..108000
	 */
	unsigned int Frequency;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * Unsigned long word 0..0xffff
	 */
	unsigned int HDStationId_DRMServiceId;
	/**
	 * Enumeration 0..0xffff
	 * 0 Analogue (FM/AM)
	 * 1 HD
	 * 2 DRM
	 */
	clCMEnum_ModulationType ModulationType;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_byte_0;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_byte_1;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_byte_2;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_byte_3;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set ATLsmSetUpSet parameters
	 */
	void setBand(clCMEnum_Band::enBand newBand);
	void setFrequency(unsigned int newFrequency);
	void setPI(unsigned short newPI);
	void setHDStationId_DRMServiceId(unsigned int newHDStationId_DRMServiceId);
	void setModulationType(clCMEnum_ModulationType::enModulationType newModulationType);
	void setRFU_byte_0(unsigned char newRFU_byte_0);
	void setRFU_byte_1(unsigned char newRFU_byte_1);
	void setRFU_byte_2(unsigned char newRFU_byte_2);
	void setRFU_byte_3(unsigned char newRFU_byte_3);
};
#endif // !defined(EA_E771496A_8B04_42b1_9EE1_08BE8A587278__INCLUDED_)
