///////////////////////////////////////////////////////////
//  clCMATHDPSDDataFrameSet.cpp
//  Implementation of the Class clCMATHDPSDDataFrameSet
//  Created on:      23-Feb-2015 2:47:12 PM
///////////////////////////////////////////////////////////

#include "clCMATHDPSDDataFrameSet.h"

clCMATHDPSDDataFrameSet::clCMATHDPSDDataFrameSet() : ProgramBitMask(0),
FieldBitMask(0),
CommentsBitMask(0),
UFIDBitMask(0),
CommercialBitMask(0) {

}

clCMATHDPSDDataFrameSet::~clCMATHDPSDDataFrameSet(){

}

tunerVector<unsigned char> clCMATHDPSDDataFrameSet::oSerialize(){

	tunerVector<unsigned char> PayLoad;

	PayLoad.push_back(ProgramBitMask);
	vAddShort(PayLoad, (short)FieldBitMask);
	PayLoad.push_back(CommentsBitMask);
	PayLoad.push_back(UFIDBitMask);
	PayLoad.push_back(CommercialBitMask);

	return  PayLoad;
}

short clCMATHDPSDDataFrameSet::u16GetSize(){

	return (sizeof(ProgramBitMask) + sizeof(FieldBitMask) + sizeof(CommentsBitMask) + sizeof(UFIDBitMask) + sizeof(CommercialBitMask));
}

void clCMATHDPSDDataFrameSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMATHDPSDDataFrameSet::setProgramBitMask(unsigned char newProgramBitMask){

	ProgramBitMask = newProgramBitMask;
}

void clCMATHDPSDDataFrameSet::setFieldBitMask(unsigned short newFieldBitMask){

	FieldBitMask = newFieldBitMask;
}

void clCMATHDPSDDataFrameSet::setCommentsBitMask(unsigned char newCommentsBitMask){

	CommentsBitMask = newCommentsBitMask;
}

void clCMATHDPSDDataFrameSet::setUFIDBitMask(unsigned char newUFIDBitMask){

	UFIDBitMask = newUFIDBitMask;
}

void clCMATHDPSDDataFrameSet::setCommercialBitMask(unsigned char newCommercialBitMask){

	CommercialBitMask = newCommercialBitMask;
}
