///////////////////////////////////////////////////////////
//  clCMATHDLongNameStatus.h
//  Implementation of the Class clCMATHDLongNameStatus
//  Created on:      11-May-2015 12:29:43 PM
///////////////////////////////////////////////////////////

#if !defined(EA_D13EC661_91C6_43c8_8E60_EC4B280369A2__INCLUDED_)
#define EA_D13EC661_91C6_43c8_8E60_EC4B280369A2__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"
#include "datatypes/tString.h"


class clCMATHDLongNameStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Unsigned byte 0 .. 0xff
	 */
	unsigned char Reserved_StatusByte0;
	unsigned char Reserved_StatusByte1;
	unsigned char Reserved_StatusByte2;
	unsigned char Reserved_StatusByte3;
	unsigned char Reserved_StatusByte4;
	unsigned char Reserved_StatusByte5;
	unsigned char Reserved_StatusByte6;
	unsigned char Reserved_StatusByte7;
	/**
	 * Enumeration 0..7
	 */
	clCMEnum_ATHDAudioProgram HDAudioProgram;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char HDTextEncoding;

	/**
	 * String 128 bytes size
	 */
	tunerString HDLongName;

	clCMATHDLongNameStatus();
	virtual ~clCMATHDLongNameStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * set ATHDLongNameStatus parameters
	 */
	void setHDStationId(unsigned int newHDStationId);
	void setReserved_StatusByte0(unsigned char newReserved_StatusByte0);
	void setReserved_StatusByte1(unsigned char newReserved_StatusByte1);
	void setReserved_StatusByte2(unsigned char newReserved_StatusByte2);
	void setReserved_StatusByte3(unsigned char newReserved_StatusByte3);
	void setReserved_StatusByte4(unsigned char newReserved_StatusByte4);
	void setReserved_StatusByte5(unsigned char newReserved_StatusByte5);
	void setReserved_StatusByte6(unsigned char newReserved_StatusByte6);
	void setReserved_StatusByte7(unsigned char newReserved_StatusByte7);
	void setHDAudioProgram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newHDAudioProgram);
	void setHDTextEncoding(unsigned char newHDTextEncoding);
	void setHDLongName(tunerString newHDLongName);
	/**
	 * read ATHDLongNameStatus parameters
	 */
	unsigned int getHDStationId();
	unsigned char getReserved_StatusByte0();
	unsigned char getReserved_StatusByte1();
	unsigned char getReserved_StatusByte2();
	unsigned char getReserved_StatusByte3();
	unsigned char getReserved_StatusByte4();
	unsigned char getReserved_StatusByte5();
	unsigned char getReserved_StatusByte6();
	unsigned char getReserved_StatusByte7();
	clCMEnum_ATHDAudioProgram::enATHDAudioProgram getHDAudioProgram();
	unsigned char getHDTextEncoding();
	const char* getHDLongName();
};
#endif // !defined(EA_D13EC661_91C6_43c8_8E60_EC4B280369A2__INCLUDED_)
