///////////////////////////////////////////////////////////
//  clCMATHDLongNameStatus.cpp
//  Implementation of the Class clCMATHDLongNameStatus
//  Created on:      11-May-2015 12:29:43 PM
///////////////////////////////////////////////////////////

#include "clCMATHDLongNameStatus.h"

#define HDLONGNAME_LEN 128

clCMATHDLongNameStatus::clCMATHDLongNameStatus() : HDStationId(0),
Reserved_StatusByte0(0),
Reserved_StatusByte1(0),
Reserved_StatusByte2(0),
Reserved_StatusByte3(0),
Reserved_StatusByte4(0),
Reserved_StatusByte5(0),
Reserved_StatusByte6(0),
Reserved_StatusByte7(0),
HDTextEncoding(0)
{

}

clCMATHDLongNameStatus::~clCMATHDLongNameStatus(){

}

tunerVector<unsigned char> clCMATHDLongNameStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMATHDLongNameStatus::u16GetSize(){

	return 0;
}

void clCMATHDLongNameStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short pos = 0;

	HDStationId = getInt(bitStream, pos);
	pos = (unsigned short)(pos + sizeof(HDStationId));

	Reserved_StatusByte0 = bitStream[pos++];
	Reserved_StatusByte1 = bitStream[pos++];
	Reserved_StatusByte2 = bitStream[pos++];
	Reserved_StatusByte3 = bitStream[pos++];
	Reserved_StatusByte4 = bitStream[pos++];
	Reserved_StatusByte5 = bitStream[pos++];
	Reserved_StatusByte6 = bitStream[pos++];
	Reserved_StatusByte7 = bitStream[pos++];

	HDAudioProgram.enType = static_cast<clCMEnum_ATHDAudioProgram::enATHDAudioProgram>(bitStream[pos++]);
	HDTextEncoding = bitStream[pos++];

	//gds5kor: move pointer by one byte to reach HDLongName. Skip 'Reserved_StatusByte'.
	pos++;
	tunerString oHDLongNameString ((const char *)&(bitStream[pos]), HDLONGNAME_LEN);
	HDLongName = oHDLongNameString;
	pos = (unsigned short)(pos + HDLONGNAME_LEN);
}

void clCMATHDLongNameStatus::setHDStationId(unsigned int newHDStationId){

	HDStationId = newHDStationId;
}
void clCMATHDLongNameStatus::setReserved_StatusByte0(unsigned char newReserved_StatusByte0){

	Reserved_StatusByte0 = newReserved_StatusByte0;
}

void clCMATHDLongNameStatus::setReserved_StatusByte1(unsigned char newReserved_StatusByte1){

	Reserved_StatusByte1 = newReserved_StatusByte1;
}

void clCMATHDLongNameStatus::setReserved_StatusByte2(unsigned char newReserved_StatusByte2){

	Reserved_StatusByte2 = newReserved_StatusByte2;
}

void clCMATHDLongNameStatus::setReserved_StatusByte3(unsigned char newReserved_StatusByte3){

	Reserved_StatusByte3 = newReserved_StatusByte3;
}

void clCMATHDLongNameStatus::setReserved_StatusByte4(unsigned char newReserved_StatusByte4){

	Reserved_StatusByte4 = newReserved_StatusByte4;
}

void clCMATHDLongNameStatus::setReserved_StatusByte5(unsigned char newReserved_StatusByte5){

	Reserved_StatusByte5 = newReserved_StatusByte5;
}

void clCMATHDLongNameStatus::setReserved_StatusByte6(unsigned char newReserved_StatusByte6){

	Reserved_StatusByte6 = newReserved_StatusByte6;
}

void clCMATHDLongNameStatus::setReserved_StatusByte7(unsigned char newReserved_StatusByte7){

	Reserved_StatusByte7 = newReserved_StatusByte7;
}

void clCMATHDLongNameStatus::setHDAudioProgram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newHDAudioProgram){

	HDAudioProgram.enType = newHDAudioProgram;
}

void clCMATHDLongNameStatus::setHDTextEncoding(unsigned char newHDTextEncoding){

	HDTextEncoding = newHDTextEncoding;
}


void clCMATHDLongNameStatus::setHDLongName(tunerString newHDLongName){

	unsigned short stringSize = (unsigned short)newHDLongName.size();
	if (newHDLongName.size() > HDLONGNAME_LEN)
	{
		stringSize = HDLONGNAME_LEN;
	}
	tunerString oString(newHDLongName.c_str(), stringSize);
	HDLongName = oString;
}

unsigned int clCMATHDLongNameStatus::getHDStationId(){

	return HDStationId;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte0(){

	return Reserved_StatusByte0;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte1(){

	return Reserved_StatusByte1;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte2(){

	return Reserved_StatusByte2;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte3(){

	return Reserved_StatusByte3;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte4(){

	return Reserved_StatusByte4;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte5(){

	return Reserved_StatusByte5;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte6(){

	return Reserved_StatusByte6;
}

unsigned char clCMATHDLongNameStatus::getReserved_StatusByte7(){

	return Reserved_StatusByte7;
}

clCMEnum_ATHDAudioProgram::enATHDAudioProgram clCMATHDLongNameStatus::getHDAudioProgram(){

	return HDAudioProgram.enType;
}

unsigned char clCMATHDLongNameStatus::getHDTextEncoding(){

	return HDTextEncoding;
}


const char* clCMATHDLongNameStatus::getHDLongName(){

	return HDLongName.c_str();
}
