///////////////////////////////////////////////////////////
//  clCMATHDLongNameGet.cpp
//  Implementation of the Class clCMATHDLongNameGet
//  Created on:      11-May-2015 10:59:19 AM
///////////////////////////////////////////////////////////

#include "clCMATHDLongNameGet.h"

clCMATHDLongNameGet::clCMATHDLongNameGet() : HDStationId(0),
Reserved_GetByte0(0),
Reserved_GetByte1(0),
Reserved_GetByte2(0),
Reserved_GetByte3(0){

}

clCMATHDLongNameGet::~clCMATHDLongNameGet(){

}

tunerVector<unsigned char> clCMATHDLongNameGet::oSerialize(){

	tunerVector<unsigned char> payload;

	vAddInt(payload, HDStationId);
	payload.push_back(Reserved_GetByte0);
	payload.push_back(Reserved_GetByte1);
	payload.push_back(Reserved_GetByte2);
	payload.push_back(Reserved_GetByte3);
	payload.push_back(static_cast<unsigned char>(HDAudioProgram.enType));

	return payload;
}

short clCMATHDLongNameGet::u16GetSize(){

	return (short)(sizeof(HDStationId) + sizeof(Reserved_GetByte0) + sizeof(Reserved_GetByte1)
			+ sizeof(Reserved_GetByte2) + sizeof(Reserved_GetByte3) + HDAudioProgram.getSize());
}

void clCMATHDLongNameGet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMATHDLongNameGet::setHDStationId(unsigned int newHDStationId){

	HDStationId = newHDStationId;
}

void clCMATHDLongNameGet::setHDAudioProgram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newHDAudioProgram){

	HDAudioProgram.enType = newHDAudioProgram;
}

void clCMATHDLongNameGet::setReserved_GetByte0(unsigned char newReserved_GetByte0){

	Reserved_GetByte0 = newReserved_GetByte0;
}

void clCMATHDLongNameGet::setReserved_GetByte1(unsigned char newReserved_GetByte1){

	Reserved_GetByte1 = newReserved_GetByte1;
}

void clCMATHDLongNameGet::setReserved_GetByte2(unsigned char newReserved_GetByte2){

	Reserved_GetByte2 = newReserved_GetByte2;
}

void clCMATHDLongNameGet::setReserved_GetByte3(unsigned char newReserved_GetByte3){

	Reserved_GetByte3 = newReserved_GetByte3;
}
