///////////////////////////////////////////////////////////
//  clCMATHDImageFileUpdateSet.h
//  Implementation of the Class clCMATHDImageFileUpdateSet
//  Created on:      07-Jul-2015 5:26:48 PM
///////////////////////////////////////////////////////////

#if !defined(EA_0924FB2B_C7A2_4d01_B9E1_D5DF32BAD706__INCLUDED_)
#define EA_0924FB2B_C7A2_4d01_B9E1_D5DF32BAD706__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATHDImageFileUpdateSet : public clADRMsgPayload
{

public:
	/**
	 * Boolean (1 byte)
	 */
	unsigned char HDAudioProgramBitMask;
	/**
	 * Enumeration 0..1, 0xff
	 * 0     Station Logo (MPS) or Service Logo (SPS 1..7)
	 * 1     Primary Image
	 * 0xff  All image types (for Set message only)
	 */
	clCMEnum_HDImageType HDImageType;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_GetByte0;
	unsigned char RFU_GetByte1;
	unsigned char RFU_GetByte2;
	unsigned char RFU_GetByte3;

	clCMATHDImageFileUpdateSet();
	virtual ~clCMATHDImageFileUpdateSet();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set ATHDImageFileUpdateSet parameters
	 */
	void setHDAudioProgramBitMask(unsigned char newHDAudioProgramBitMask);
	void setHDImageType(clCMEnum_HDImageType::enHDImageType newHDImageType);
	void setRFU_GetByte0(unsigned char newRFU_GetByte0);
	void setRFU_GetByte1(unsigned char newRFU_GetByte0);
	void setRFU_GetByte2(unsigned char newRFU_GetByte0);
	void setRFU_GetByte3(unsigned char newRFU_GetByte0);

};
#endif // !defined(EA_0924FB2B_C7A2_4d01_B9E1_D5DF32BAD706__INCLUDED_)
