///////////////////////////////////////////////////////////
//  clCMATHDGetImageFileStatus.h
//  Implementation of the Class clCMATHDGetImageFileStatus
//  Created on:      06-Jul-2015 8:40:39 PM
///////////////////////////////////////////////////////////

#if !defined(EA_D8644210_89E9_495a_9F5F_8FF8588F100A__INCLUDED_)
#define EA_D8644210_89E9_495a_9F5F_8FF8588F100A__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATHDGetImageFileStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_StatusByte0;
	unsigned char RFU_StatusByte1;
	/**
	 * Enumeration 0..1
	 * 0 Station Logo (MPS) or Service Logo (SPS 1..7)
	 * 1 Primary Image
	 */
	clCMEnum_HDImageType HDImageType;
	/**
	 * Enumeration 0..1
	 * 0 Image is coded in jpg format
	 * 1 Image is coded in png format
	 */
	clCMEnum_HDImageCoding HDImageCoding;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char ReservedByte_0;
	unsigned char ReservedByte_1;
	unsigned char ReservedByte_2;
	unsigned char ReservedByte_3;
	unsigned char ReservedByte_4;
	unsigned char ReservedByte_5;
	unsigned char ReservedByte_6;
	unsigned char ReservedByte_7;
	/**
	 * Enumeration 0..7
	 * 0 Audio program 1
	 * 1..7 Audio program 2 .. 8
	 */
	clCMEnum_HDAudioService HDAudioService;
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDApplicationMimeType;
	/**
	 * Unsigned word
	 */
	unsigned short LOTID;
	/**
	 * Unsigned long word
	 */
	unsigned int NumberOfImageFileBytes;
	/**
	 * Stream byte 0, byte 1, .. byte n
	 */
	tunerVector<unsigned char> ImageFileBytes;

	clCMATHDGetImageFileStatus();
	virtual ~clCMATHDGetImageFileStatus();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Read ATHDGetImageFileStatus parameters
	 */
	unsigned int getHDStationId();
	clCMEnum_HDImageType::enHDImageType getHDImageType();
	clCMEnum_HDImageCoding::enHDImageCoding getHDImageCoding();
	clCMEnum_HDAudioService::enHDAudioService getHDAudioService();
	unsigned int getHDApplicationMimeType();
	unsigned short getLOTID();
	unsigned int getNumberOfImageFileBytes();
	tunerVector<unsigned char> getImageFileBytes();

};
#endif // !defined(EA_D8644210_89E9_495a_9F5F_8FF8588F100A__INCLUDED_)
