///////////////////////////////////////////////////////////
//  clCMATHDGetImageFileStatus.cpp
//  Implementation of the Class clCMATHDGetImageFileStatus
//  Created on:      06-Jul-2015 8:40:39 PM
///////////////////////////////////////////////////////////

#include "clCMATHDGetImageFileStatus.h"

clCMATHDGetImageFileStatus::clCMATHDGetImageFileStatus() : HDStationId(0),
RFU_StatusByte0(0),
RFU_StatusByte1(0),
ReservedByte_0(0),
ReservedByte_1(0),
ReservedByte_2(0),
ReservedByte_3(0),
ReservedByte_4(0),
ReservedByte_5(0),
ReservedByte_6(0),
ReservedByte_7(0),
HDApplicationMimeType(0),
LOTID(0),
NumberOfImageFileBytes(0){

}

clCMATHDGetImageFileStatus::~clCMATHDGetImageFileStatus(){

}

tunerVector<unsigned char> clCMATHDGetImageFileStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMATHDGetImageFileStatus::u16GetSize(){

	return 0;
}


void clCMATHDGetImageFileStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position=0;

	HDStationId = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(HDStationId));

	RFU_StatusByte0 = bitStream[position++];
	RFU_StatusByte1 = bitStream[position++];

	HDImageType.enType = static_cast<clCMEnum_HDImageType::enHDImageType>(bitStream[position++]);
	HDImageCoding.enType = static_cast<clCMEnum_HDImageCoding::enHDImageCoding>(bitStream[position++]);

	ReservedByte_0 = bitStream[position++];
	ReservedByte_1 = bitStream[position++];
	ReservedByte_2 = bitStream[position++];
	ReservedByte_3 = bitStream[position++];
	ReservedByte_4 = bitStream[position++];
	ReservedByte_5 = bitStream[position++];
	ReservedByte_6 = bitStream[position++];
	ReservedByte_7 = bitStream[position++];

	HDAudioService.enType = static_cast<clCMEnum_HDAudioService::enHDAudioService>(bitStream[position++]);

	HDApplicationMimeType = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(HDApplicationMimeType));

	unsigned char MSB = bitStream[position++];
	unsigned char LSB = bitStream[position++];
	LOTID = getWord(LSB, MSB);

	NumberOfImageFileBytes = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(NumberOfImageFileBytes));

	for(int CurrentPosition = position, nImageBytes = NumberOfImageFileBytes;
			(int)NumberOfImageFileBytes > (int)(CurrentPosition - position) && nImageBytes > 0;
			CurrentPosition++, nImageBytes--)
	{
		ImageFileBytes.push_back(bitStream[CurrentPosition]);
	}
}

unsigned int clCMATHDGetImageFileStatus::getHDStationId()
{
	return HDStationId;
}

clCMEnum_HDImageType::enHDImageType clCMATHDGetImageFileStatus::getHDImageType()
{
	return HDImageType.enType;
}

clCMEnum_HDImageCoding::enHDImageCoding clCMATHDGetImageFileStatus::getHDImageCoding()
{
	return HDImageCoding.enType;
}

clCMEnum_HDAudioService::enHDAudioService clCMATHDGetImageFileStatus::getHDAudioService()
{
	return HDAudioService.enType;
}

unsigned int clCMATHDGetImageFileStatus::getHDApplicationMimeType()
{
	return HDApplicationMimeType;
}

unsigned short clCMATHDGetImageFileStatus::getLOTID()
{
	return LOTID;
}

unsigned int clCMATHDGetImageFileStatus::getNumberOfImageFileBytes()
{
	return NumberOfImageFileBytes;
}

tunerVector<unsigned char> clCMATHDGetImageFileStatus::getImageFileBytes()
{
	return ImageFileBytes;
}
