///////////////////////////////////////////////////////////
//  clCMATHDGetImageFileGet.cpp
//  Implementation of the Class clCMATHDGetImageFileGet
//  Created on:      06-Jul-2015 8:40:32 PM
///////////////////////////////////////////////////////////

#include "clCMATHDGetImageFileGet.h"

clCMATHDGetImageFileGet::clCMATHDGetImageFileGet() : HDStationId(0),
RFU_GetByte0(0),
RFU_GetByte1(0),
RFU_GetByte2(0),
RFU_GetByte3(0){

}

clCMATHDGetImageFileGet::~clCMATHDGetImageFileGet(){

}

tunerVector<unsigned char> clCMATHDGetImageFileGet::oSerialize(){

	tunerVector<unsigned char> payload;

	vAddInt(payload, HDStationId);
	payload.push_back(static_cast<unsigned char>(HDAudioProgram.enType));
	payload.push_back(static_cast<unsigned char>(HDImageType.enType));
	payload.push_back(RFU_GetByte0);
	payload.push_back(RFU_GetByte1);
	payload.push_back(RFU_GetByte2);
	payload.push_back(RFU_GetByte3);

	return payload;
}

short clCMATHDGetImageFileGet::u16GetSize(){

	short size = 0;
	size = (short)(sizeof(HDStationId) + HDAudioProgram.getSize() + HDImageType.getSize());
	size = (short)(size + sizeof(RFU_GetByte0) + sizeof(RFU_GetByte1) + sizeof(RFU_GetByte2) + sizeof(RFU_GetByte3));
	return size;
}

void clCMATHDGetImageFileGet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMATHDGetImageFileGet::setHDStationId(unsigned int newHDStationId)
{
	HDStationId = newHDStationId;
}

void clCMATHDGetImageFileGet::setHDAudioProgram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newHDAudioProgram)
{
	HDAudioProgram.enType = newHDAudioProgram;
}

void clCMATHDGetImageFileGet::setHDImageType(clCMEnum_HDImageType::enHDImageType newHDImageType)
{
	HDImageType.enType = newHDImageType;
}

void clCMATHDGetImageFileGet::setRFU_GetByte0(unsigned char newRFU_GetByte0)
{
	RFU_GetByte0 =newRFU_GetByte0;
}

void clCMATHDGetImageFileGet::setRFU_GetByte1(unsigned char newRFU_GetByte1)
{
	RFU_GetByte1 = newRFU_GetByte1;
}

void clCMATHDGetImageFileGet::setRFU_GetByte2(unsigned char newRFU_GetByte2)
{
	RFU_GetByte2 = newRFU_GetByte2;
}

void clCMATHDGetImageFileGet::setRFU_GetByte3(unsigned char newRFU_GetByte3)
{
	RFU_GetByte3 = newRFU_GetByte3;
}
