///////////////////////////////////////////////////////////
//  clCMATBandStatus.cpp
//  Implementation of the Class clCMATBandStatus
//  Created on:      10-Feb-2015 8:37:10 PM
///////////////////////////////////////////////////////////

#include "clCMATBandStatus.h"
#include "clByteConverter.h"


clCMATBandStatus::clCMATBandStatus() :
Frequency(0),
PI(0),
Stationname(""),
HDCallSign(""),
HDStationId(0),
ActivePresetList(0),
PresetAutocompare(0),
DRMServiceLabel(""),
DRMServiceId(0),
rfu_byte_0(0),
rfu_byte_1(0),
rfu_byte_2(0),
rfu_byte_3(0),
rfu_byte_4(0),
rfu_byte_5(0),
rfu_byte_6(0),
rfu_byte_7(0),
rfu_byte_8(0),
rfu_byte_9(0),
rfu_byte_10(0),
rfu_byte_11(0),
rfu_byte_12(0),
rfu_byte_13(0),
rfu_byte_14(0),
rfu_byte_15(0),
rfu_byte_16(0),
rfu_byte_17(0),
rfu_byte_18(0) {

}

clCMATBandStatus::~clCMATBandStatus(){

}

tunerVector<unsigned char> clCMATBandStatus::oSerialize(){

	tunerVector<unsigned char>PayLoadData;
	return  PayLoadData;
}

short clCMATBandStatus::u16GetSize(){

	return 0;
}

void clCMATBandStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position=0;

	Band.enType = static_cast<clCMEnum_Band::enBand>(bitStream[position++]);

	Frequency = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(Frequency));

	unsigned short LSB = (unsigned short)(position+1);
	unsigned short MSB = position;
	PI = getWord(bitStream[LSB], bitStream[MSB]);
	position = (unsigned short)(position + sizeof(PI));

	tunerString oStationnameString ((const char *)&(bitStream[position]), STATIONNAME_LEN);
	Stationname = oStationnameString;
	position = (unsigned short)(position + STATIONNAME_LEN);

	tunerString oHDCallSignString ((const char *)&(bitStream[position]), HDCALLSIGN_LEN);
	HDCallSign = oHDCallSignString;
	position = (unsigned short)(position + HDCALLSIGN_LEN);

	HDStationId = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(HDStationId));

	HDAudioService.enType = static_cast<clCMEnum_HDAudioService::enHDAudioService>(bitStream[position++]);
	LSB = (unsigned short)(position+1);
	MSB = position;

	ActivePresetList = getWord(bitStream[LSB], bitStream[MSB]);
	position = (unsigned short)(position + sizeof(ActivePresetList));

	PresetAutocompare = bitStream[position++];

	tunerString oDRMServiceLabelString ((const char *)&(bitStream[position]), DRMSERVICELABEL_LEN);
	DRMServiceLabel = oDRMServiceLabelString;
	position = (unsigned short)(position + DRMSERVICELABEL_LEN);

	DRMServiceId = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(DRMServiceId));

	DRMServiceShortId.enType = static_cast<clCMEnum_DRMServiceShortId::enDRMServiceShortId>(bitStream[position++]);

	ConstructRFUBytes(bitStream, position);
}

void clCMATBandStatus::ConstructRFUBytes(tunerVector<unsigned char> &bitStream, unsigned short position)
{
	rfu_byte_0 = bitStream[position++];
	rfu_byte_1 = bitStream[position++];
	rfu_byte_2 = bitStream[position++];
	rfu_byte_3 = bitStream[position++];
	rfu_byte_4 = bitStream[position++];
	rfu_byte_5 = bitStream[position++];
	rfu_byte_6 = bitStream[position++];
	rfu_byte_7 = bitStream[position++];
	rfu_byte_8 = bitStream[position++];
	rfu_byte_9 = bitStream[position++];
	rfu_byte_10 = bitStream[position++];
	rfu_byte_11 = bitStream[position++];
	rfu_byte_12 = bitStream[position++];
	rfu_byte_13 = bitStream[position++];
	rfu_byte_14 = bitStream[position++];
	rfu_byte_15 = bitStream[position++];
	rfu_byte_16 = bitStream[position++];
	rfu_byte_17 = bitStream[position++];
	rfu_byte_18 = bitStream[position++];
}

void clCMATBandStatus::setBand(clCMEnum_Band::enBand newBand)
{
	Band.enType = newBand;
}

void clCMATBandStatus::setFrequency(unsigned int newFrequency)
{
	Frequency = newFrequency;
}

void clCMATBandStatus::setPI(unsigned short newPI)
{
	PI = newPI;
}

void clCMATBandStatus::setStationname(tunerString newStationname)
{
	unsigned short stringSize = (unsigned short)newStationname.size();
	if (newStationname.size() > STATIONNAME_LEN)
	{
		stringSize = STATIONNAME_LEN;
	}
	tunerString oString(newStationname.c_str(), stringSize);
	Stationname = oString;
}

void clCMATBandStatus::setHDCallSign(tunerString newHDCallSign)
{
	unsigned short stringSize = (unsigned short)newHDCallSign.size();
	if (newHDCallSign.size() > HDCALLSIGN_LEN)
	{
		stringSize = HDCALLSIGN_LEN;
	}
	tunerString oString(newHDCallSign.c_str(), stringSize);
	HDCallSign = oString;
}

void clCMATBandStatus::setHDStationId(unsigned int newHDStationId)
{
	HDStationId = newHDStationId;
}

void clCMATBandStatus::setHDAudioService(clCMEnum_HDAudioService::enHDAudioService newHDAudioService)
{
	HDAudioService.enType = newHDAudioService;
}

void clCMATBandStatus::setActivePresetList(unsigned short newActivePresetList)
{
	ActivePresetList = newActivePresetList;
}

void clCMATBandStatus::setPresetAutocompare(unsigned char newPresetAutocompare){

	PresetAutocompare = newPresetAutocompare;
}

void clCMATBandStatus::setDRMServiceLabel(tunerString newDRMServiceLabel){
	
	unsigned short stringSize = (unsigned short)newDRMServiceLabel.size();
	if (newDRMServiceLabel.size() > DRMSERVICELABEL_LEN)
	{
		stringSize = DRMSERVICELABEL_LEN;
	}
	tunerString oString(newDRMServiceLabel.c_str(), stringSize);
	DRMServiceLabel = oString;
}

void clCMATBandStatus::setDRMServiceId(unsigned int newDRMServiceId){

	DRMServiceId = newDRMServiceId;
}

void clCMATBandStatus::setDRMServiceShortId(clCMEnum_DRMServiceShortId::enDRMServiceShortId newDRMServiceShortId){

	DRMServiceShortId.enType = newDRMServiceShortId;
}

 clCMEnum_Band::enBand clCMATBandStatus::getBand() const{

	return Band.enType;
}

unsigned long clCMATBandStatus::getFrequency() const{

	return Frequency;
}

unsigned short clCMATBandStatus::getPI() const{

	return PI;
}

const char * clCMATBandStatus::getStationname() const{

	return Stationname.c_str();
}

const char * clCMATBandStatus::getHDCallSign() const{

	return HDCallSign.c_str();
}

unsigned long clCMATBandStatus::getHDStationId() const{

	return HDStationId;
}

clCMEnum_HDAudioService::enHDAudioService clCMATBandStatus::getHDAudioService() const{

	return HDAudioService.enType;
}

unsigned short clCMATBandStatus::getActivePresetList() const{

	return ActivePresetList;
}

unsigned char clCMATBandStatus::getPresetAutocompare() const{

	return PresetAutocompare;
}

const char * clCMATBandStatus::getDRMServiceLabel() const{

	return DRMServiceLabel.c_str();
}

unsigned long clCMATBandStatus::getDRMServiceId() const{

	return DRMServiceId;
}

clCMEnum_DRMServiceShortId::enDRMServiceShortId clCMATBandStatus::getDRMServiceShortId() const{

	return DRMServiceShortId.enType;
}

tunerVector<unsigned char> clCMATBandStatus::getrfu_bytes() {

	tunerVector<unsigned char> rfu_bytes;

	rfu_bytes.push_back(rfu_byte_0);
	rfu_bytes.push_back(rfu_byte_1);
	rfu_bytes.push_back(rfu_byte_2);
	rfu_bytes.push_back(rfu_byte_3);
	rfu_bytes.push_back(rfu_byte_4);
	rfu_bytes.push_back(rfu_byte_5);
	rfu_bytes.push_back(rfu_byte_6);
	rfu_bytes.push_back(rfu_byte_7);
	rfu_bytes.push_back(rfu_byte_8);
	rfu_bytes.push_back(rfu_byte_9);
	rfu_bytes.push_back(rfu_byte_10);
	rfu_bytes.push_back(rfu_byte_11);
	rfu_bytes.push_back(rfu_byte_12);
	rfu_bytes.push_back(rfu_byte_13);
	rfu_bytes.push_back(rfu_byte_14);
	rfu_bytes.push_back(rfu_byte_15);
	rfu_bytes.push_back(rfu_byte_16);
	rfu_bytes.push_back(rfu_byte_17);
	rfu_bytes.push_back(rfu_byte_18);

	return rfu_bytes;
}

void clCMATBandStatus::setrfu_bytes(tunerVector<unsigned char> newrfu_bytes){

	unsigned short index = 0;

	rfu_byte_0 = newrfu_bytes[index++];
	rfu_byte_1 = newrfu_bytes[index++];
	rfu_byte_2 = newrfu_bytes[index++];
	rfu_byte_3 = newrfu_bytes[index++];
	rfu_byte_4 = newrfu_bytes[index++];
	rfu_byte_5 = newrfu_bytes[index++];
	rfu_byte_6 = newrfu_bytes[index++];
	rfu_byte_7 = newrfu_bytes[index++];
	rfu_byte_8 = newrfu_bytes[index++];
	rfu_byte_9 = newrfu_bytes[index++];
	rfu_byte_10 = newrfu_bytes[index++];
	rfu_byte_11 = newrfu_bytes[index++];
	rfu_byte_12 = newrfu_bytes[index++];
	rfu_byte_13 = newrfu_bytes[index++];
	rfu_byte_14 = newrfu_bytes[index++];
	rfu_byte_15 = newrfu_bytes[index++];
	rfu_byte_16 = newrfu_bytes[index++];
	rfu_byte_17 = newrfu_bytes[index++];
	rfu_byte_18 = newrfu_bytes[index++];
}