///////////////////////////////////////////////////////////
//  clByteConverter.h
//  Implementation of the Class clByteConverter
//  Created on:      09-Jan-2015 15:05:57
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_464F3C77_ED48_4c58_858E_15702CC4457C__INCLUDED_)
#define EA_464F3C77_ED48_4c58_858E_15702CC4457C__INCLUDED_

#include "datatypes/tVector.h"

/**
 * provides functionality to convert variables to bytes.
 * @author pad1cob
 * @version 1.0
 * @updated 13-Jan-2015 10:10:46
 */
class clByteConverter
{

public:
	clByteConverter();
	virtual ~clByteConverter();

	/**
	 * returns the LSB
	 * 
	 * @param word
	 */
	unsigned char getLSB(short word);
	/**
	 * returns the MSB
	 * 
	 * @param word
	 */
	unsigned char getMSB(short word);
	/**
	 * combines two bytes to a word
	 * 
	 * @param LSB
	 * @param MSB
	 */
	unsigned short getWord(unsigned char LSB, unsigned char MSB);
	/**
	 * Read the last byte in the bitstream and also remove that value from vector.
	 * 
	 * @param bitStream
	 */
	unsigned char popLastByte(tunerVector<unsigned char> & bitStream);

	/*
	 * Add integer to payload vector */
	void vAddInt( tunerVector<unsigned char>& payload ,unsigned long word);

	/*
	 * Add 3 bytes value to payload vector */
	void vAdd3Bytes( tunerVector<unsigned char>& payloadData , int word);
	
	/*
	 * Add short to payload vector */
	void vAddShort(tunerVector<unsigned char>& payload , unsigned short word);
	/*
	 * Read integer from stream */
	unsigned int getInt(unsigned char first, unsigned char second, unsigned char third, unsigned char fourth);
	/*
	 * Read integer from payload vector wherea as position was provided by index */
	unsigned int getInt(tunerVector<unsigned char>& payload, unsigned int index);
	/*
	 * Add string to payload vector */
   void vAddString( tunerVector<unsigned char>& payload ,unsigned char * poString, unsigned short size);
   /*
   	* Construct string from payload vector */
   void vConstructString( tunerVector<unsigned char>& payload ,unsigned char * poString, unsigned short size, unsigned short& position);
   /*
      	* Construct 3 bytes value from payload vector */
   unsigned int Construct3Bytes(tunerVector<unsigned char> bitStream, unsigned short &position);
   
   /*  Copy constructor  */
		
	clByteConverter(const clByteConverter &/*Converter*/)
	{}
   
   /*  Copy assignment operator  */
		
	clByteConverter &operator=(clByteConverter &Converter)
	{
		if(this==&Converter){
		return *this;
		}
		return Converter;
	}
	
	/*  Move assignment operator  */
		
	clByteConverter &operator=(clByteConverter &&Converter)
	{
		if(this==&Converter){
		return *this;
		}
		return Converter;
	}

};
#endif // !defined(EA_464F3C77_ED48_4c58_858E_15702CC4457C__INCLUDED_)
