///////////////////////////////////////////////////////////
//  clByteConverter.cpp
//  Implementation of the Class clByteConverter
//  Created on:      09-Jan-2015 15:05:57
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clByteConverter.h"


clByteConverter::clByteConverter(){

}



clByteConverter::~clByteConverter(){

}





unsigned char clByteConverter::getLSB(short word){

	return  (unsigned char)(  word & 0x00ff);
}


unsigned char clByteConverter::getMSB(short word){

	return   (unsigned char)(( word & 0xff00) >> 8  );
}


unsigned short clByteConverter::getWord(unsigned char LSB, unsigned char MSB){

   return (unsigned short)(((MSB <<8) & 0xff00) | LSB);
	//return ((LSB <<8) & 0xff00) | MSB ;
}


unsigned char clByteConverter::popLastByte(tunerVector<unsigned char> & bitStream){

	unsigned char byte = 0;
	if (!bitStream.empty())
	{
		byte = bitStream.back();
		bitStream.pop_back();
	}
	return byte;
}


void clByteConverter::vAddInt( tunerVector<unsigned char>& payloadData ,unsigned long word)
{
	payloadData.push_back(( word & 0xff000000) >> 24 );
	payloadData.push_back(( word & 0x00ff0000) >> 16 );
	payloadData.push_back(( word & 0x0000ff00) >> 8  );
	payloadData.push_back( word & 0x000000ff);
}

void clByteConverter::vAdd3Bytes( tunerVector<unsigned char>& payloadData , int word)
{
	payloadData.push_back((unsigned char)(( word & 0x00ff0000) >> 16) );
	payloadData.push_back((unsigned char)(( word & 0x0000ff00) >> 8)  );
	payloadData.push_back( (unsigned char)(word & 0x000000ff) );
}

void clByteConverter::vAddShort(tunerVector<unsigned char>& payloadData ,unsigned short word)
{
	payloadData.push_back((unsigned char)(( word & 0xff00) >> 8)  );
	payloadData.push_back( (unsigned char)(word & 0x00ff) );
}

unsigned int clByteConverter::getInt(unsigned char first, unsigned char second, unsigned char third, unsigned char fourth)
{
	unsigned int doubleWord;
	doubleWord  = ( unsigned int ) ( ( (unsigned int)  first ) << 24 ) ;
	doubleWord |= ( unsigned int ) ( ( (unsigned int)  second) << 16 ) ;
	doubleWord |= ( unsigned int ) ( ( (unsigned int)  third ) << 8  ) ;
	doubleWord |= ( unsigned int ) fourth;
	return doubleWord;
}


unsigned int clByteConverter::getInt(tunerVector<unsigned char>& payload, unsigned int index)
{
	unsigned int u32data = 0;

	if(payload.size() >= index+sizeof(unsigned int))
	{
		u32data = (unsigned int)(payload[index])<<24;
		u32data += (unsigned int)(payload[index+1])<<16;
		u32data += (unsigned int)(payload[index+2])<<8;
		u32data += (unsigned int)(payload[index+3]);
	}

	return u32data;
}



void clByteConverter::vAddString(  tunerVector<unsigned char>& payload ,unsigned char * poString, unsigned short size)
{
   for (unsigned short index = 0; index < size; index++)
   {
      payload.push_back(*poString);
      poString++;
   }
}


void clByteConverter::vConstructString( tunerVector<unsigned char>& payload ,unsigned char * poString, unsigned short size, unsigned short& position) {

	for (unsigned short index = 0; index < size; index++)
	{
	*poString =  payload[position++];
	 poString++;
	}
}

unsigned int clByteConverter::Construct3Bytes(tunerVector<unsigned char> bitStream, unsigned short &position)
{
	unsigned int u32data = 0;

	if(bitStream.size() >= position+sizeof(unsigned int))
	{
		u32data += (unsigned int)(bitStream[position++])<<16;
		u32data += (unsigned int)(bitStream[position++])<<8;
		u32data += (unsigned int)(bitStream[position++]);
	}
	return u32data;
}