///////////////////////////////////////////////////////////
//  clATPIStatus.h
//  Implementation of the Class clATPIStatus
//  Created on:      26-Mar-2015 5:53:26 PM
///////////////////////////////////////////////////////////

#if !defined(EA_F7F87F42_F00B_40ee_B53C_D913A292A97D__INCLUDED_)
#define EA_F7F87F42_F00B_40ee_B53C_D913A292A97D__INCLUDED_

#include "clADRMsgPayload.h"

class clATPIStatus : public clADRMsgPayload
{

public:
    /**
     * unsigned word 0..0xffff
     */
    unsigned short u16PI;
    /**
     * unsigned int
     * 76000..108000
     */
    unsigned int u32Frequency;

    clATPIStatus();
    virtual ~clATPIStatus();
    /**
     * serialize the data stream
     */
    tunerVector<unsigned char> oSerialize();
    /**
     * set value of PI
     */
    void setPI(unsigned short newPI);
    /**
     * set value of Frequency
     */
    void setFrequency(unsigned int newFrequency);
    /**
     * read value of PI
     */
    unsigned short getPI();
    /**
     * read value of Frequency
     */
    unsigned int getFrequency();
    /**
     * returns size of payload
     */
    short u16GetSize();
    /**
     * construct payload
     */
    void vConstruct(tunerVector<unsigned char> bitStream);

};
#endif // !defined(EA_F7F87F42_F00B_40ee_B53C_D913A292A97D__INCLUDED_)
