///////////////////////////////////////////////////////////
//  clADRMsgHeader.h
//  Implementation of the Class clADRMsgHeader
//  Created on:      09-Jan-2015 14:59:01
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_74B18BAE_8305_4fa2_9782_33CFA4DCE81D__INCLUDED_)
#define EA_74B18BAE_8305_4fa2_9782_33CFA4DCE81D__INCLUDED_

/**
 * header class which is added for all ADR functions.
 * @author pad1cob
 * @version 1.0
 * @created 09-Jan-2015 14:59:01
 */
class clADRMsgHeader
{

public:
	clADRMsgHeader();
	virtual ~clADRMsgHeader();

	short getu16ClientId();
	short getu16FBlockId();
	/**
	 * The function ID as specified in ADR interface document
	 */
	unsigned short getu16FunctionId();
	char getu8InstanceId();
	/**
	 * The instance ID as specified in ADR interface document
	 */
	char getu8OpCode();
	/**
	 * 
	 * @param newVal
	 */
	void setu16ClientId(short newVal);
	/**
	 * 
	 * @param newVal
	 */
	void setu16FBlockId(short newVal);
	/**
	 * The function ID as specified in ADR interface document
	 * 
	 * @param newVal
	 */
	void setu16FunctionId(unsigned short newVal);
	/**
	 * 
	 * @param newVal
	 */
	void setu8InstanceId(char newVal);
	/**
	 * The instance ID as specified in ADR interface document
	 * 
	 * @param newVal
	 */
	void setu8OpCode(char newVal);

private:
	/**
	 * The client ID as specified in ADR interface document
	 */
	short u16ClientId;
	/**
	 * The fblock ID as specified in ADR interface document
	 */
	short u16FBlockId;
	/**
	 * The function ID as specified in ADR interface document
	 */
	unsigned short u16FunctionId;
	/**
	 * The instance ID as specified in ADR interface document
	 */
	char u8InstanceId;
	/**
	 * The optype as specified in ADR interface document
	 */
	char u8OpCode;

};
#endif // !defined(EA_74B18BAE_8305_4fa2_9782_33CFA4DCE81D__INCLUDED_)
